import json
import random
import argparse

parser = argparse.ArgumentParser()

parser.add_argument('--triples_path', type=str, default='./argonly_typed_arguments_documented.json')

args = parser.parse_args()

print("Loading triples from %s" % args.triples_path)
with open(args.triples_path, 'r', encoding='utf8') as fp:
	triples = json.load(fp)

print("Triples read in! Drawing samples......")

for i in range(100):
	doc_id = random.choice(list(triples.keys()))
	doc = triples[doc_id]
	print("Document %s: " % doc_id)

	if 'sents' in doc:
		for sent_id in range(len(doc['rels'])):
			sent = doc['sents'][sent_id]
			rels = doc['rels'][sent_id]
			print("Sentence %d: %s" % (sent_id, sent))
			print("Rels: ")
			for rel in rels:
				print(rel)
			print("")
	else:
		for sent_id in range(len(doc)):
			rels = doc[sent_id]
			for rel in rels:
				print(rel)
	print("")

print("Done!")
