# Examples #

Rich examples are included to demonstrate the use of Texar. The implementations of cutting-edge models/algorithms also provide references for reproducibility and comparisons. 

More examples are continuously added...

## Examples by Models/Algorithms ##

### RNN / Seq2seq ###

* [seq2seq_attn](./seq2seq_attn): Attentional seq2seq

### Transformer (Self-attention) ###

* [transformer](./transformer): Transformer for machine translation
* [bert](./bert): Pre-trained BERT model for text representation
* [gpt-2](./gpt-2): Pre-trained OpenAI GPT-2 language model
* [xlnet](./xlnet): Pre-trained XLNet language model
* [vae_text](./vae_text): VAE with a transformer decoder for improved language modeling 

### Variational Autoencoder (VAE) ###

* [vae_text](./vae_text): VAE language model

### Classifier / Sequence Prediction ###

* [bert](./bert): Pre-trained BERT model for text representation
* [sentence_classifier](./sentence_classifier): Basic CNN-based sentence classifier
* [xlnet](./xlnet): Pre-trained XLNet model for text classification/regression

---

## Examples by Tasks

### Language Modeling ###

* [gpt-2](./gpt-2): Pre-trained OpenAI GPT-2 language model
* [vae_text](./vae_text): VAE language model
* [xlnet](./xlnet): Pre-trained XLNet language model

### Machine Translation ###

* [seq2seq_attn](./seq2seq_attn): Attentional seq2seq
* [transformer](./transformer): Transformer for machine translation

### Classification ###

* [bert](./bert): Pre-trained BERT model for text representation
* [sentence_classifier](./sentence_classifier): Basic CNN-based sentence classifier
* [xlnet](./xlnet): Pre-trained XLNet model for text classification/regression

