import argparse
import glob
import os


RESULT_DIR = "result"


def write_result(args):
    if not os.path.exists(RESULT_DIR):
        os.mkdir(RESULT_DIR)

    model_dir = os.path.join(args.model_dir, f"{args.task}")
    ckpt_lst = glob.glob(f"{model_dir}*")

    result_lines = []

    for ckpt_path in ckpt_lst:
        task_name = ckpt_path.split("/")[-1]
        best_result_filepath = os.path.join(ckpt_path, "best_result.txt")
        if os.path.exists(best_result_filepath):
            with open(best_result_filepath, "r", encoding="utf-8") as f:
                best_result_str = f.read().strip()
            result_lines.append(f"[{task_name}] {best_result_str}")

    with open(os.path.join(RESULT_DIR, f"{args.task}.txt"), "w", encoding="utf-8") as f:
        for line in result_lines:
            f.write(line)
            f.write("\n")


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--task", type=str, required=True)
    parser.add_argument("--model_dir", type=str, required=True)
    args = parser.parse_args()

    write_result(args)
