#!/bin/bash

# CONFIG_EN="config/config_GenEAE_ace05isi_mbart50_en_lang_eos-triggerword_template-roletype.json"
# CONFIG_AR="config/config_GenEAE_ace05isi_mbart50_ar_lang_eos-triggerword_template-roletype.json"
# CONFIG_ZH="config/config_GenEAE_ace05ep_mbart50_zh_lang_eos-triggerword_template-roletype.json"

# CONFIG_EN="config/config_GenEAE_ace05isi_mbart50copy_en_lang_eos-triggerword_template-roletype.json"
# CONFIG_AR="config/config_GenEAE_ace05isi_mbart50copy_ar_lang_eos-triggerword_template-roletype.json"
# CONFIG_ZH="config/config_GenEAE_ace05ep_mbart50copy_zh_lang_eos-triggerword_template-roletype.json"

# CONFIG_EN="config/config_GenEAE_ace05isi_mT5_en-triggerword_template-roletype.json"
# CONFIG_AR="config/config_GenEAE_ace05isi_mT5_ar-triggerword_template-roletype.json"
# CONFIG_ZH="config/config_GenEAE_ace05ep_mT5_zh-triggerword_template-roletype.json"

# CONFIG_EN="config/config_GenEAE_ace05isi_mT5copy_en-triggerword_template-roletype.json"
# CONFIG_AR="config/config_GenEAE_ace05isi_mT5copy_ar-triggerword_template-roletype.json"
# CONFIG_ZH="config/config_GenEAE_ace05ep_mT5copy_zh-triggerword_template-roletype.json"

# CONFIG_EN="config/config_GenEAE_ace05isi_mT5-base_en-triggerword_template-roletype.json"
# CONFIG_AR="config/config_GenEAE_ace05isi_mT5-base_ar-triggerword_template-roletype.json"
# CONFIG_ZH="config/config_GenEAE_ace05ep_mT5-base_zh-triggerword_template-roletype.json"

# CONFIG_EN="config/config_GenEAE_ace05isi_mT5copy-base_en-triggerword_template-roletype.json"
# CONFIG_AR="config/config_GenEAE_ace05isi_mT5copy-base_ar-triggerword_template-roletype.json"
# CONFIG_ZH="config/config_GenEAE_ace05ep_mT5copy-base_zh-triggerword_template-roletype.json"

CONFIG_EN="config/config_GenEAE_ace05isi_mT5copy-base_en-triggerword_template-englishrole.json"
CONFIG_AR="config/config_GenEAE_ace05isi_mT5copy-base_ar-triggerword_template-englishrole.json"
CONFIG_ZH="config/config_GenEAE_ace05ep_mT5copy-base_zh-triggerword_template-englishrole.json"

# CONFIG_EN="config/config_GenEAE_ace05isi_mT5copy-base_en-entype_triggerword_template-roletype.json"
# CONFIG_AR="config/config_GenEAE_ace05isi_mT5copy-base_ar-entype_triggerword_template-roletype.json"
# CONFIG_ZH="config/config_GenEAE_ace05ep_mT5copy-base_zh-entype_triggerword_template-roletype.json"

# CONFIG_EN="config/config_GenEAE_ace05isi_mT5copy-base_en-specialtype_triggerword_template-roletype.json"
# CONFIG_AR="config/config_GenEAE_ace05isi_mT5copy-base_ar-specialtype_triggerword_template-roletype.json"
# CONFIG_ZH="config/config_GenEAE_ace05ep_mT5copy-base_zh-specialtype_triggerword_template-roletype.json"

TEST_EN="../Data/ACE_processed/ace05isi_en_xlmroberta/test.w1.oneie.json"
TEST_AR="../Data/ACE_processed/ace05isi_ar_xlmroberta/test.w1.oneie.json"
TEST_ZH="../Data/ACE_processed/ace05ep_zh_xlmroberta/test.w1.oneie.json"

GPU=$1
MODEL=$2
LANG=$3

export CUDA_VISIBLE_DEVICES=$GPU

echo "standard beam 4"
echo $CONFIG_EN
python eval_pipelineEE.py -ceae $CONFIG_EN -eae $MODEL -g -w predictions/$LANG/en --no_dev --beam=4
python ../BaseModel/external_scorer.py -p predictions/$LANG/en/test.pred.json -g $TEST_EN

echo $CONFIG_AR
python eval_pipelineEE.py -ceae $CONFIG_AR -eae $MODEL -g -w predictions/$LANG/ar --no_dev --beam=4
python ../BaseModel/external_scorer.py -p predictions/$LANG/ar/test.pred.json -g $TEST_AR

echo $CONFIG_ZH
python eval_pipelineEE.py -ceae $CONFIG_ZH -eae $MODEL -g -w predictions/$LANG/zh --no_dev --beam=4
python ../BaseModel/external_scorer.py -p predictions/$LANG/zh/test.pred.json -g $TEST_ZH
echo "======================="

echo "constrained beam 4"
echo $CONFIG_EN
python eval_pipelineEE.py -ceae $CONFIG_EN -eae $MODEL -g -w predictions/$LANG/en --no_dev --constrained_decode --beam=4
python ../BaseModel/external_scorer.py -p predictions/$LANG/en/test.pred.json -g $TEST_EN

echo $CONFIG_AR
python eval_pipelineEE.py -ceae $CONFIG_AR -eae $MODEL -g -w predictions/$LANG/ar --no_dev --constrained_decode --beam=4
python ../BaseModel/external_scorer.py -p predictions/$LANG/ar/test.pred.json -g $TEST_AR

echo $CONFIG_ZH
python eval_pipelineEE.py -ceae $CONFIG_ZH -eae $MODEL -g -w predictions/$LANG/zh --no_dev --constrained_decode --beam=4
python ../BaseModel/external_scorer.py -p predictions/$LANG/zh/test.pred.json -g $TEST_ZH
echo "======================="
