# ==================================   INDEP   ================================== #
from ..data_config import SIZE

######### Grain grain_num > 1 #########
Indep_Template_Prl_Grain = [
    # (+) =======================================
    # (+) if token and hyperfields, then it is simply the squeeze operation.
    # (+) if subfields, it will run.
    [ 
        # STRUCTURE:
            'Tensor_Reducer',    
        # Meanings:
            {
                'InputMeaning':    'GrainVec_SeqAS_Token_SeqAS_Sent',
                'OutputMeaning':   'TokenVec_SeqAS_Sent',
                'Reshape_Restore': 'GrainVec_SeqAs_Token',
            },
        # NNName_NNPara
            [
                # NN Name
                'Mean',
                # NN Para
                {'type': 'mean', 
                 'input_size':  SIZE, 
                 'output_size': SIZE,
                 'postprecess' :{
                     'dropout' :[False, {'p':0.5, 'inplace':False}],
                     'layernorm': [True, {'eps': 1e-05, "elementwise_affine":False}],
                    }

                }
            ]
    ],
    
    # (+) =======================================
    # (+) if token and hyperfields, then it is running on the sentence level. 
    # (+) It is the first step of token and hyperfields.
    # (+) if subfields, it will run.
    # [ 
    #     # STRUCTURE:
    #         'Matrix_Extractor',    
    #     # Meanings:
    #         {
    #             'InputMeaning':  'TokenVec_SeqAS_Sent',
    #             'OutputMeaning': 'TokenVec_SeqAS_Sent',
    #             'Reshape_Restore': None,
    #         },
    #     # NNName_NNPara
    #         [
    #             # empty
    #             # NN Name
    #             'RNN',
    #             # NN Para
    #             {'type': 'lstm', 
    #              'n_layers': 1,
    #              'input_type': 'INPUT-NML', 'direction_type': 'BI-MIX',  'struct_type': 'EXTRACTOR', 
    #              'input_size': SIZE,  'output_size': SIZE, 'rnn_dropout': 0.5,
    #              'postprecess' :{
    #                  'dropout' :[False, {'p':0.5, 'inplace':False}],
    #                  # 'activiator': [True, 'relu'],
    #                  'layernorm': [True, {'eps': 1e-05, "elementwise_affine":False}],
    #                 }
    #             }
    #         ]
    # ]
]


# ==================================   INTERDEP  ================================== #

Interdep_Template = [
    # (+) DON'T CHANGE THIS PART =======================================
    [ 
        # STRUCTURE:
            'Tensor_Reducer',    
        # Meanings:
            {
                'InputMeaning':    'FieldVec_SeqAS_Token_SeqAS_Sent',
                'OutputMeaning':   'TokenVec_SeqAS_Sent',
                'Reshape_Restore':  None,
            },
        # NNName_NNPara
            [
                # NN Name
                'Sum',
                # NN Para
                {'type': 'sum', 
                 'input_size':  SIZE, 
                 'output_size': SIZE,
                 'postprecess' :{
                     'dropout' :[False, {'p':0.5, 'inplace':False}],
                     'layernorm': [True, {'eps': 1e-05, "elementwise_affine":False}],
                    }

                }
            ]
    ],
    
    # (+) =======================================
    # [ 
    #     # STRUCTURE:
    #         'Matrix_Extractor',    
    #     # Meanings:
    #         {
    #             'InputMeaning':  'TokenVec_SeqAS_Sent',
    #             'OutputMeaning': 'TokenVec_SeqAS_Sent',
    #             'Reshape_Restore': None,
    #         },
    #     # NNName_NNPara
    #         [
    #             empty
    #             # NN Name
    #             'RNN',
    #             # NN Para
    #             {'type': 'lstm', 
    #              'n_layers': 1,
    #              'input_type': 'INPUT-NML', 
    #              'direction_type': 'BI-MIX',  
    #              'struct_type': 'EXTRACTOR', 
    #              'input_size': SIZE,  'output_size': SIZE, 'rnn_dropout': 0.5,
    #              'postprecess' :{
    #                  'dropout' :[False, {'p':0.5, 'inplace':False}],
    #                  # 'activiator': [True, 'relu'],
    #                  'layernorm': [True, {'eps': 1e-05, "elementwise_affine":False}],
    #                 }
    #             }
    #         ]
    # ]
]
