/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.parex;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhraseTable {
    public static final String UNK = "<UNK>";
    private Hashtable<String, Integer> dict = new Hashtable();
    private Hashtable<Integer, String> revDict = new Hashtable();
    private int nextWordInt = 0;
    private Node base = new Node();
    private ArrayList<int[]> phrases = new ArrayList();
    private ArrayList<Double> probs = new ArrayList();
    private int nextPhraseIx = 0;

    public int mapWord(String string) {
        Integer n = this.dict.get(string);
        if (n == null) {
            n = this.nextWordInt;
            this.dict.put(string, this.nextWordInt);
            this.revDict.put(this.nextWordInt, string);
            ++this.nextWordInt;
        }
        return n;
    }

    public String unmapWord(int n) {
        String string = this.revDict.get(n);
        if (string == null) {
            string = UNK;
        }
        return string;
    }

    public int[] mapPhrase(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int[] nArray = new int[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            nArray[n] = this.mapWord(stringTokenizer.nextToken());
            ++n;
        }
        return nArray;
    }

    public String unmapPhrase(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int n : nArray) {
            stringBuilder.append(this.unmapWord(n));
            stringBuilder.append(" ");
        }
        return stringBuilder.toString().trim();
    }

    public void addPhrasePair(String string, String string2, double d) {
        int[] nArray = this.mapPhrase(string);
        int[] nArray2 = this.mapPhrase(string2);
        this.addPhrasePair(nArray, nArray2, d);
    }

    public void addPhrasePair(int[] nArray, int[] nArray2, double d) {
        Node node = this.base;
        for (int n : nArray) {
            Node node2 = node.next.get(n);
            if (node2 == null) {
                node2 = new Node();
                node.next.put(n, node2);
            }
            node = node2;
        }
        this.phrases.add(nArray2);
        this.probs.add(d);
        int[] nArray3 = new int[node.phraseIdx.length + 1];
        for (int i = 0; i < node.phraseIdx.length; ++i) {
            nArray3[i] = node.phraseIdx[i];
        }
        nArray3[node.phraseIdx.length] = this.nextPhraseIx++;
        node.phraseIdx = nArray3;
    }

    public ArrayList<Phrase> getPhrases(String string) {
        int[] nArray = this.mapPhrase(string);
        return this.getPhrases(nArray);
    }

    public ArrayList<Phrase> getPhrases(int[] nArray) {
        Node node = this.base;
        for (int n : nArray) {
            Node node2 = node.next.get(n);
            if (node2 == null) {
                return new ArrayList<Phrase>();
            }
            node = node2;
        }
        Object object = new ArrayList();
        for (int n : node.phraseIdx) {
            ((ArrayList)object).add(new Phrase(this.unmapPhrase(this.phrases.get(n)), this.phrases.get(n), this.probs.get(n)));
        }
        return object;
    }

    public class Phrase {
        String phrase;
        int[] words;
        double prob;

        public Phrase(String string, int[] nArray, double d) {
            this.phrase = string;
            this.words = nArray;
            this.prob = d;
        }
    }

    private class Node {
        public Hashtable<Integer, Node> next = new Hashtable();
        public int[] phraseIdx = new int[0];

        private Node() {
        }
    }
}

