/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import simplenlg.exception.SimplenlgException;
import simplenlg.features.Case;
import simplenlg.features.Category;
import simplenlg.features.DiscourseFunction;
import simplenlg.features.Form;
import simplenlg.features.InterrogativeType;
import simplenlg.features.NumberAgr;
import simplenlg.features.Person;
import simplenlg.features.Position;
import simplenlg.features.Tense;
import simplenlg.lexicon.LexiconInterface;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.lexicon.lexicalitems.Verb;
import simplenlg.realiser.CoordinateNPPhraseSpec;
import simplenlg.realiser.CoordinatePhraseSet;
import simplenlg.realiser.CoordinateVPPhraseSpec;
import simplenlg.realiser.HeadedPhraseSpec;
import simplenlg.realiser.NPPhraseSpec;
import simplenlg.realiser.PPPhraseSpec;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.Realiser;
import simplenlg.realiser.SPhraseSpec;
import simplenlg.realiser.StringPhraseSpec;
import simplenlg.realiser.VPPhraseSpec;
import simplenlg.realiser.comparators.WordOrder;

public class VPPhraseSpec
extends HeadedPhraseSpec<Verb> {
    boolean perfect;
    boolean progressive;
    boolean passive;
    boolean realiseAuxiliary;
    boolean mainVerbPerfect;
    Verb modal;
    List<Verb> modals;
    Tense tense;
    Person person;
    NumberAgr number;
    Form form;
    String auxiliaryRealisation;
    String mainVerbRealisation;
    PPPhraseSpec passiveComplement;
    Position passiveComplementPosition;
    boolean passiveComplementRealisation;
    CoordinatePhraseSet<Phrase> surfaceSubject;
    String finiteVerbRealisation;
    String verbClusterRealisation;
    List<String> constituentRealisation;
    String vorfeldRealisation;
    HashMap<Position, List<Phrase>> constituentMap;
    WordOrder wordOrder;
    boolean suppressVorfeld;
    boolean honorific;
    Stack<String> vgComponents;
    boolean suppressSubject;
    boolean suppressObject;
    boolean suppressIndirectObject;
    boolean interrogative;
    InterrogativeType interrogType;
    DiscourseFunction whArgument;

    public VPPhraseSpec() {
        this.category = Category.VERB;
        this.perfect = false;
        this.progressive = false;
        this.passive = false;
        this.negated = false;
        this.modal = null;
        this.modals = new ArrayList<Verb>();
        this.tense = Tense.PRESENT;
        this.person = Person.THIRD;
        this.number = NumberAgr.SINGULAR;
        this.form = Form.NORMAL;
        this.head = new Verb("");
        this.realiseAuxiliary = true;
        this.auxiliaryRealisation = "";
        this.mainVerbRealisation = "";
        this.mainVerbPerfect = false;
        this.vgComponents = new Stack();
        this.suppressSubject = false;
        this.suppressObject = false;
        this.suppressIndirectObject = false;
        this.honorific = false;
        this.interrogative = false;
        this.interrogType = null;
        this.whArgument = DiscourseFunction.NULL;
        this.wordOrder = WordOrder.SIO;
        this.constituentMap = new HashMap();
        this.constituentRealisation = new ArrayList<String>();
        this.surfaceSubject = new CoordinatePhraseSet<VPPhraseSpec>(this);
        this.passiveComplement = null;
        this.passiveComplementPosition = Position.DEFAULT;
        this.passiveComplementRealisation = true;
    }

    public VPPhraseSpec(String v) {
        this();
        this.setHead(v);
    }

    public VPPhraseSpec(Verb v) {
        this();
        this.setHead(v);
    }

    @Override
    public void setHead(String v) {
        this.head = this.castToVerb(v);
    }

    @Override
    public void addComplement(Object comp) {
        this.addComplement(comp, DiscourseFunction.OBJECT);
    }

    public void addComplement(Object comp, DiscourseFunction function) {
        if (!(function.equals(DiscourseFunction.SUBJECT) || function.equals(DiscourseFunction.OBJECT) || function.equals(DiscourseFunction.INDIRECT_OBJECT) || function.equals(DiscourseFunction.GENITIVE_OBJECT))) {
            throw new SimplenlgException("Complements of a verb phrase can only be assigned the functionsOBJECT, GENITIVE_OBJECT, INDIRECT_OBJECT, SUBJECT");
        }
        this.addConstituent(function.mapToPosition(), comp);
    }

    public void addIndirectObject(Object object) {
        this.addComplement(object, DiscourseFunction.INDIRECT_OBJECT);
    }

    public void setComplement(Object comp, DiscourseFunction function) {
        if (!(function.equals(DiscourseFunction.SUBJECT) || function.equals(DiscourseFunction.OBJECT) || function.equals(DiscourseFunction.INDIRECT_OBJECT) || function.equals(DiscourseFunction.GENITIVE_OBJECT))) {
            throw new SimplenlgException("Complements of a verb phrase can only be assigned the functionsOBJECT, GENITIVE_OBJECT, INDIRECT_OBJECT, SUBJECT");
        }
        this.setConstituent(function.mapToPosition(), comp);
    }

    public boolean hasComplements(DiscourseFunction function) {
        if (function.equals(DiscourseFunction.SUBJECT) || function.equals(DiscourseFunction.OBJECT) || function.equals(DiscourseFunction.INDIRECT_OBJECT) || function.equals(DiscourseFunction.GENITIVE_OBJECT)) {
            return this.hasConstituents(function.mapToPosition());
        }
        throw new SimplenlgException("Complements of a verb phrase can only be assigned the functionsOBJECT, GENITIVE_OBJECT, INDIRECT_OBJECT, SUBJECT");
    }

    @Override
    @Deprecated
    public void setPremodifier(Object mod) {
        this.addPremodifier(mod);
    }

    @Override
    @Deprecated
    public void addPremodifier(Object mod) {
        this.addModifier(Position.FRONT, mod);
    }

    @Override
    @Deprecated
    public void setPostmodifier(Object mod) {
        this.addModifier(mod);
    }

    @Override
    @Deprecated
    public void addPostmodifier(Object mod) {
        this.addModifier(mod);
    }

    @Override
    @Deprecated
    public void addAttributivePostmodifier(Object mod) {
        this.addModifier(mod);
    }

    @Override
    @Deprecated
    public boolean hasPremodifiers() {
        return super.hasPremodifiers();
    }

    @Override
    @Deprecated
    public boolean hasPostmodifiers() {
        return super.hasPostmodifiers();
    }

    @Override
    @Deprecated
    public boolean hasAttributivePostmodifiers() {
        return super.hasAttributivePostmodifiers();
    }

    @Override
    @Deprecated
    public List<Phrase> getPremodifiers() {
        return super.getPremodifiers();
    }

    @Override
    @Deprecated
    public List<Phrase> getPostmodifiers() {
        return super.getPostmodifiers();
    }

    @Override
    @Deprecated
    public List<Phrase> getAttributivePostmodifiers() {
        return super.getAttributivePostmodifiers();
    }

    @Override
    public void addModifier(Object modifier) {
        this.addModifier(Position.DEFAULT, modifier);
    }

    public void addModifier(Position pos, Object mod) {
        this.addConstituent(pos, mod);
    }

    public List<Phrase> getModifiers(Position pos) {
        return this.getConstituents(pos);
    }

    public void setInterrogative(Object obj, DiscourseFunction func, boolean fronted) {
        if (obj instanceof InterrogativeType) {
            this.interrogType = (InterrogativeType)obj;
            this.interrogative = true;
            this.whArgument = obj.equals(InterrogativeType.JA_NEIN) ? null : func;
        } else {
            this.interrogType = InterrogativeType.WH_ELEMENT;
            this.interrogative = true;
            if (fronted) {
                if (func.isComplementFunction()) {
                    this.addComplement(obj, func);
                    this.wordOrder = this.wordOrder.getFrontedVariant(func.mapToPosition());
                } else {
                    this.addModifier(Position.FRONT, obj);
                }
            } else if (func.isComplementFunction()) {
                this.addComplement(obj, func);
            } else {
                this.addModifier(func.mapToPosition(), obj);
            }
        }
    }

    public void deleteInterrogative() {
        this.interrogative = false;
        this.interrogType = null;
        this.whArgument = null;
    }

    public boolean isInterrogative() {
        return this.interrogative;
    }

    public InterrogativeType getInterrogativeType() {
        return this.interrogType;
    }

    public DiscourseFunction getWhArgument() {
        return this.whArgument;
    }

    protected void addConstituent(Position pos, Object con) {
        Phrase element = this.makeConstituent(con, pos.mapToFunction());
        if (this.constituentMap.containsKey(pos)) {
            this.constituentMap.get(pos).add(element);
        } else {
            ArrayList<Phrase> elemList = new ArrayList<Phrase>();
            elemList.add(element);
            this.constituentMap.put(pos, elemList);
        }
    }

    protected void setConstituent(Position pos, Object con) {
        Phrase element = this.makeConstituent(con, pos.mapToFunction());
        ArrayList<Phrase> elemList = new ArrayList<Phrase>();
        elemList.add(element);
        this.constituentMap.put(pos, elemList);
    }

    public List<Phrase> getConstituents(Position pos) {
        return this.constituentMap.containsKey(pos) ? this.constituentMap.get(pos) : null;
    }

    public boolean hasConstituents(Position pos) {
        return this.constituentMap.containsKey(pos) && !this.constituentMap.get(pos).isEmpty();
    }

    public void setForm(Form f) {
        this.form = f;
        if (this.form == Form.GERUND || this.form == Form.INFINITIVE || this.form == Form.BARE_INFINITIVE) {
            this.tense = Tense.PRESENT;
        }
    }

    public Form getForm() {
        return this.form;
    }

    public void setPassive(boolean pass) {
        this.passive = pass;
    }

    public boolean isPassive() {
        return this.passive;
    }

    public void setProgressive(boolean prog) {
        this.progressive = prog;
    }

    public boolean isProgressive() {
        return this.progressive;
    }

    public void setPerfect(boolean perf) {
        this.perfect = perf;
    }

    public boolean isPerfect() {
        return this.perfect;
    }

    @Override
    public void setNegated(boolean neg) {
        this.negated = neg;
    }

    @Override
    public boolean isNegated() {
        return this.negated;
    }

    public void setTense(Tense t) {
        this.tense = t;
    }

    public Tense getTense() {
        return this.tense;
    }

    public Verb getModal() {
        return this.modal;
    }

    public void setModal(String modal) {
        this.modals.clear();
        this.addModal(modal);
    }

    public void setModal(Verb modal) {
        this.modals.clear();
        this.addModal(modal);
    }

    public void addModal(String modal) {
        this.modals.add(Constants.getModal(modal));
    }

    public void addModal(Verb modal) {
        this.modals.add(modal);
    }

    public boolean isMainVerbPerfect() {
        return this.mainVerbPerfect;
    }

    public void setMainVerbPerfect(boolean mainVerbPerfect) {
        this.mainVerbPerfect = mainVerbPerfect;
    }

    public void setPerson(Person p) {
        this.person = p;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setNumber(NumberAgr n) {
        this.number = n;
    }

    public NumberAgr getNumber() {
        return this.number;
    }

    public void setParticle(String particle) {
        ((Verb)this.head).setParticle(particle);
    }

    public boolean isHonorific() {
        return this.honorific;
    }

    public void setHonorific(boolean honorific) {
        this.honorific = honorific;
    }

    public boolean isSuppressVorfeld() {
        return this.suppressVorfeld;
    }

    public void setSuppressVorfeld(boolean suppressVorfeld) {
        this.suppressVorfeld = suppressVorfeld;
    }

    public void setImperativeForm(NumberAgr num, boolean honorific) {
        this.form = Form.IMPERATIVE;
        this.number = num;
        this.honorific = honorific;
    }

    public WordOrder getWordOrder() {
        return this.wordOrder;
    }

    public void setWordOrder(WordOrder wordOrder) {
        this.wordOrder = wordOrder;
    }

    public Position getPassiveComplementPosition() {
        return this.passiveComplementPosition;
    }

    public void setPassiveComplementPosition(Position passiveComplementPosition) {
        this.passiveComplementPosition = passiveComplementPosition;
    }

    public boolean isPassiveComplementRealisation() {
        return this.passiveComplementRealisation;
    }

    public void setPassiveComplementRealisation(boolean passiveComplementRealisation) {
        this.passiveComplementRealisation = passiveComplementRealisation;
    }

    public List<Phrase> getComplements(DiscourseFunction func) {
        Position pos = func.mapToPosition();
        return this.constituentMap.containsKey(pos) ? this.constituentMap.get(pos) : null;
    }

    public List<Phrase> getPassiveRaisingComplements() {
        List<Object> objects = new ArrayList();
        if (this.constituentMap.containsKey(Position.OBJECT)) {
            objects = this.constituentMap.get(Position.OBJECT);
        } else {
            if (this.constituentMap.containsKey(Position.INDIRECT_OBJECT)) {
                for (Phrase p : this.constituentMap.get(Position.INDIRECT_OBJECT)) {
                    if (p instanceof PPPhraseSpec && !p.isElided()) {
                        objects.addAll(((PPPhraseSpec)p).getComplements());
                        continue;
                    }
                    if (p.isElided()) continue;
                    objects.add(p);
                }
            }
            if (objects.isEmpty()) {
                NPPhraseSpec np = new NPPhraseSpec(Constants.PRO_EXPLETIVE);
                objects.add(np);
            }
        }
        return this.flagRaisedNPs(objects, true);
    }

    public boolean hasSameFeatures(VPPhraseSpec vp) {
        return this.passive == vp.passive && this.perfect == vp.perfect && this.negated == vp.negated && this.progressive == vp.progressive && this.person == vp.person && this.number == vp.number;
    }

    public VPPhraseSpec coordinate(Phrase ... coords) {
        if (coords.length == 0) {
            return this;
        }
        CoordinateVPPhraseSpec coord = new CoordinateVPPhraseSpec(this);
        try {
            for (Phrase p : coords) {
                coord.addCoordinates((VPPhraseSpec)p);
            }
            return coord;
        }
        catch (ClassCastException cce) {
            throw new SimplenlgException("Cannot coordinate: only phrases of the same type can be coordinated");
        }
    }

    public void realiseAuxiliary(boolean aux) {
        this.realiseAuxiliary = aux;
    }

    @Override
    public boolean equals(Object o) {
        VPPhraseSpec vp;
        boolean eq = false;
        if (o instanceof VPPhraseSpec && super.equals(vp = (VPPhraseSpec)o)) {
            eq = this.tense == vp.tense && this.perfect == vp.perfect && this.passive == vp.passive && this.progressive == vp.progressive;
        }
        return eq;
    }

    String realise(Realiser r, boolean subordinate) {
        HashMap constituentMapBackup = (HashMap)this.constituentMap.clone();
        this.computeSurfaceArgs();
        this.computeAgreement();
        this.realiseVerbGroup(r, subordinate);
        this.computeComplementRealisation(r);
        this.realiseConstituents(r);
        this.constituentMap = constituentMapBackup;
        String vorfeldText = "";
        if (!this.isSuppressVorfeld() && !this.getForm().equals(Form.IMPERATIVE) && (vorfeldText = this.constituentRealisation.remove(0)).equals(",")) {
            vorfeldText = this.constituentRealisation.remove(0);
            vorfeldText = vorfeldText + this.constituentRealisation.remove(0);
        }
        String mittelfeldText = r.realiseList(this.constituentRealisation);
        if (this.negated) {
            mittelfeldText = r.appendSpace(mittelfeldText, "nicht");
        }
        if (subordinate) {
            return r.appendSpace(vorfeldText, mittelfeldText, this.verbClusterRealisation, this.finiteVerbRealisation);
        }
        return r.appendSpace(vorfeldText, this.finiteVerbRealisation, mittelfeldText, this.verbClusterRealisation);
    }

    @Override
    String realise(Realiser r) {
        return this.realise(r, false);
    }

    String getInterrogativeFrontedElement(LexiconInterface lex) {
        if (this.vgComponents.size() == 1 && !((Verb)this.head).isCopular()) {
            return lex.getVerbForm("do", this.tense, this.person, this.number);
        }
        if (!this.vgComponents.empty()) {
            return this.vgComponents.peek();
        }
        return null;
    }

    protected void computeSurfaceArgs() {
        this.surfaceSubject.clearCoordinates();
        this.passiveComplement = null;
        if (this.isPassive()) {
            if (this.interrogative && this.interrogType.isWhQuestion()) {
                switch (1.$SwitchMap$simplenlg$features$DiscourseFunction[this.whArgument.ordinal()]) {
                    case 1: {
                        this.buildPassiveInterrogativeComplement();
                        this.surfaceSubject.addCoordinates(this.getPassiveRaisingComplements());
                        break;
                    }
                    case 2: {
                        this.suppressArg(DiscourseFunction.INDIRECT_OBJECT);
                        this.surfaceSubject.addCoordinates(this.getPassiveRaisingComplements());
                        this.buildPassiveComplement();
                        break;
                    }
                    default: {
                        this.buildPassiveComplement();
                        this.whArgument = DiscourseFunction.SUBJECT;
                        break;
                    }
                }
            } else {
                this.surfaceSubject.addCoordinates(this.getPassiveRaisingComplements());
                this.buildPassiveComplement();
            }
        } else if (this.interrogative && this.interrogType.isWhQuestion()) {
            switch (1.$SwitchMap$simplenlg$features$DiscourseFunction[this.whArgument.ordinal()]) {
                case 1: {
                    break;
                }
                default: {
                    this.suppressArg(this.whArgument);
                    this.surfaceSubject.addCoordinates(this.getComplements(DiscourseFunction.SUBJECT));
                    break;
                }
            }
        } else {
            this.surfaceSubject.addCoordinates(this.getComplements(DiscourseFunction.SUBJECT));
        }
        if (this.passiveComplement != null && this.passiveComplementRealisation) {
            this.addModifier(this.passiveComplementPosition, this.passiveComplement);
        }
        if (this.interrogative) {
            if (this.interrogType == InterrogativeType.JA_NEIN) {
                this.setSuppressVorfeld(true);
            } else if (!this.interrogType.equals(InterrogativeType.WH_ELEMENT)) {
                NPPhraseSpec inp = (NPPhraseSpec)this.makeConstituent(new NPPhraseSpec(Constants.getInterrogative(this.interrogType)), this.whArgument);
                inp.setCase(this.whArgument.getCaseValue());
                this.addConstituent(Position.FRONT, inp);
            }
        }
    }

    void computeRealisation(Realiser r, boolean interrogative) {
        this.mainVerbRealisation = "";
        this.auxiliaryRealisation = "";
        boolean mainVerbSeen = false;
        String omit = null;
        if (interrogative) {
            omit = this.getInterrogativeFrontedElement(r.getLexicon());
        }
        for (String word : this.vgComponents) {
            boolean skip;
            boolean bl = skip = omit != null && word.equals(omit);
            if (!mainVerbSeen) {
                if (!skip) {
                    this.mainVerbRealisation = r.appendSpace(word, this.mainVerbRealisation);
                }
                if (word.equalsIgnoreCase("not")) continue;
                mainVerbSeen = true;
                continue;
            }
            if (skip) continue;
            this.auxiliaryRealisation = r.appendSpace(word, this.auxiliaryRealisation);
        }
    }

    void realiseVerbGroup(Realiser r, boolean subordinate) {
        String participle;
        this.vgComponents.clear();
        this.finiteVerbRealisation = "";
        this.verbClusterRealisation = "";
        if (this.getDiscourseFunction() != DiscourseFunction.NULL && this.form == Form.NORMAL) {
            switch (1.$SwitchMap$simplenlg$features$DiscourseFunction[this.getDiscourseFunction().ordinal()]) {
                case 1: {
                    this.form = Form.ZU_INFINITIVE;
                    break;
                }
                default: {
                    this.form = Form.BARE_INFINITIVE;
                }
            }
        }
        Verb finiteVerb = (Verb)this.head;
        if (this.passive) {
            this.verbClusterRealisation = r.appendSpace(finiteVerb.getPerfectParticiple(), this.verbClusterRealisation);
            finiteVerb = Constants.getAuxiliary("werden");
        }
        if (this.modals.isEmpty()) {
            if (this.perfect || this.mainVerbPerfect) {
                participle = this.passive ? "worden" : finiteVerb.getPerfectParticiple();
                this.verbClusterRealisation = r.appendSpace(this.verbClusterRealisation, participle);
                finiteVerb = Constants.getAuxiliary(finiteVerb.getAuxType());
            }
        } else {
            if (this.mainVerbPerfect) {
                participle = this.passive ? "worden" : finiteVerb.getPerfectParticiple();
                this.verbClusterRealisation = r.appendSpace(this.verbClusterRealisation, participle);
                finiteVerb = Constants.getAuxiliary(finiteVerb.getAuxType());
            }
            if (this.form != Form.IMPERATIVE) {
                for (Verb m : this.modals) {
                    this.verbClusterRealisation = r.appendSpace(this.verbClusterRealisation, finiteVerb.getInfinitive());
                    finiteVerb = m;
                }
                if (this.perfect) {
                    this.verbClusterRealisation = r.appendSpace(this.verbClusterRealisation, finiteVerb.getInfinitive());
                    finiteVerb = Constants.getAuxiliary(finiteVerb.getAuxType());
                }
            }
        }
        if (this.tense == Tense.FUTURE && this.form != Form.IMPERATIVE) {
            this.verbClusterRealisation = r.appendSpace(this.verbClusterRealisation, finiteVerb.getInfinitive());
            finiteVerb = Constants.getAuxiliary("werden");
        }
        if (finiteVerb != null) {
            if (this.form == Form.BARE_INFINITIVE || this.form == Form.INFINITIVE) {
                this.verbClusterRealisation = r.appendSpace(this.verbClusterRealisation, finiteVerb.getInfinitive());
            } else if (this.form == Form.ZU_INFINITIVE) {
                this.verbClusterRealisation = r.appendSpace(this.verbClusterRealisation, finiteVerb.getZuInfinitive());
            } else if (this.form == Form.IMPERATIVE) {
                this.finiteVerbRealisation = this.honorific ? finiteVerb.getHonorificImperativeForm() : finiteVerb.getImperativeForm(this.number);
                if (finiteVerb.hasVerbPrefix()) {
                    this.verbClusterRealisation = r.appendSpace(finiteVerb.getVerbPrefix(), this.verbClusterRealisation);
                }
            } else {
                NumberAgr numToUse = this.getNumber();
                Tense tenseToUse = this.tense == Tense.FUTURE ? Tense.PRESENT : this.tense;
                this.finiteVerbRealisation = finiteVerb.getForm(this.person, numToUse, tenseToUse, this.form);
                if (finiteVerb.hasVerbPrefix()) {
                    if (subordinate) {
                        this.finiteVerbRealisation = finiteVerb.getVerbPrefix().concat(this.finiteVerbRealisation);
                    } else {
                        this.verbClusterRealisation = r.appendSpace(finiteVerb.getVerbPrefix(), this.verbClusterRealisation);
                    }
                }
            }
        }
    }

    private boolean hasPluralComplement() {
        boolean plur = false;
        for (Phrase comp : this.complements) {
            if (!(comp instanceof NPPhraseSpec) || ((NPPhraseSpec)comp).getNumber() != NumberAgr.PLURAL) continue;
            plur = true;
            break;
        }
        return plur;
    }

    @Override
    String realiseComplement(Realiser r) {
        return "";
    }

    private void realiseConstituents(Realiser r) {
        this.constituentRealisation.clear();
        block4: for (Position pos : this.wordOrder.getPositions()) {
            if (pos.equals(Position.SUBJECT)) {
                if (this.suppressSubject) continue;
                this.computeComplementCase();
                this.constituentRealisation.add(this.surfaceSubject.realise(r));
                continue;
            }
            if (!this.constituentMap.containsKey(pos)) continue;
            List<Phrase> phrases = this.constituentMap.get(pos);
            switch (1.$SwitchMap$simplenlg$features$Position[pos.ordinal()]) {
                case 1: {
                    if (this.suppressObject) continue block4;
                    this.computeComplementCase();
                    this.constituentRealisation.add(r.realiseAndList(phrases));
                    break;
                }
                case 2: {
                    if (this.suppressIndirectObject) continue block4;
                    this.computeComplementCase();
                    for (Phrase p : this.collectIndirectObjectsByCategory(phrases)) {
                        this.constituentRealisation.add(r.realise(p));
                    }
                    continue block4;
                }
                default: {
                    for (Phrase p : phrases) {
                        if (p instanceof SPhraseSpec) {
                            this.constituentRealisation.add(",");
                            this.constituentRealisation.add(r.realise(p));
                            this.constituentRealisation.add(",");
                            continue;
                        }
                        this.constituentRealisation.add(r.realise(p));
                    }
                    continue block4;
                }
            }
        }
        if (this.constituentRealisation.isEmpty()) {
            this.constituentRealisation.add("");
        }
    }

    private void computeAgreement() {
        if (this.getForm() == Form.IMPERATIVE) {
            return;
        }
        List<Phrase> agreeNP = this.surfaceSubject.getCoordinates();
        this.setNumber(this.getNumberFeature(agreeNP));
        this.setPerson(this.getPersonFeature(agreeNP));
    }

    private void computeComplementRealisation(Realiser r) {
        if (this.passive) {
            List<Phrase> passiveRaisingComplements = this.getPassiveRaisingComplements();
            for (Position key : this.constituentMap.keySet()) {
                this.constituentMap.get(key).removeAll(passiveRaisingComplements);
            }
        }
        for (Position pos : Position.values()) {
            if (!this.constituentMap.containsKey(pos) || !pos.isComplementPosition()) continue;
            Collections.sort(this.constituentMap.get(pos), this.complementComparator);
        }
    }

    private void computeComplementCase() {
        for (Position pos : Position.values()) {
            if (!pos.isComplementPosition() || !this.constituentMap.containsKey(pos)) continue;
            DiscourseFunction df = pos.mapToFunction();
            Case cs = df.getCaseValue();
            for (Phrase p : this.constituentMap.get(pos)) {
                if (p == null) continue;
                if (!df.equals(DiscourseFunction.NULL)) {
                    p.setDiscourseFunction(df);
                }
                if (!(p instanceof NPPhraseSpec)) continue;
                ((NPPhraseSpec)p).setCase(cs);
            }
        }
        if (this.surfaceSubject.hasCoordinates()) {
            Case cs = this.getDiscourseFunction().equals(DiscourseFunction.OBJECT) ? Case.ACCUSATIVE : Case.NOMINATIVE;
            for (Phrase p : this.surfaceSubject.coordinates) {
                if (!(p instanceof NPPhraseSpec)) continue;
                ((NPPhraseSpec)p).setCase(cs);
            }
        }
    }

    private List<Phrase> collectIndirectObjectsByCategory(List<Phrase> indirectObjects) {
        ListIterator<Phrase> iterator = indirectObjects.listIterator();
        ArrayList<Phrase> result = new ArrayList<Phrase>();
        NPPhraseSpec lastNP = null;
        while (iterator.hasNext()) {
            Phrase next = iterator.next();
            if (next instanceof NPPhraseSpec) {
                NPPhraseSpec np = (NPPhraseSpec)next;
                if (lastNP != null) {
                    result.remove(lastNP);
                    if (lastNP instanceof CoordinateNPPhraseSpec) {
                        ((CoordinateNPPhraseSpec)lastNP).addCoordinates(np);
                        np = lastNP;
                    } else {
                        np = lastNP.coordinate(new Phrase[]{np});
                    }
                }
                lastNP = np;
                result.add(np);
                continue;
            }
            result.add(next);
        }
        return result;
    }

    void suppressArg(DiscourseFunction function) {
        if (function.equals(DiscourseFunction.OBJECT)) {
            this.suppressObject = true;
        } else if (function.equals(DiscourseFunction.INDIRECT_OBJECT)) {
            this.suppressIndirectObject = true;
        } else if (function.equals(DiscourseFunction.SUBJECT)) {
            this.suppressSubject = true;
        }
    }

    void initialiseArgs() {
        this.suppressIndirectObject = false;
        this.suppressObject = false;
        this.suppressSubject = false;
        this.flagRaisedNPs(this.complements, false);
    }

    protected Person getPersonFeature(List<Phrase> agreeNP) {
        Phrase agr;
        if (agreeNP.size() == 1 && (agr = agreeNP.get(0)) instanceof NPPhraseSpec) {
            return ((NPPhraseSpec)agr).getPerson();
        }
        return Person.THIRD;
    }

    protected NumberAgr getNumberFeature(List<Phrase> agreeNP) {
        if (agreeNP.size() == 1) {
            Phrase agr = agreeNP.get(0);
            if (agr instanceof NPPhraseSpec) {
                return ((NPPhraseSpec)agr).getNumber();
            }
            if (agr instanceof StringPhraseSpec && ((StringPhraseSpec)agr).isPlural()) {
                return NumberAgr.PLURAL;
            }
            if (agr.isCoordinate()) {
                return NumberAgr.PLURAL;
            }
        } else if (agreeNP.size() > 1) {
            return NumberAgr.PLURAL;
        }
        return NumberAgr.SINGULAR;
    }

    void buildPassiveComplement() {
        List<Phrase> actualSubjects = this.getNonElidedSubjects();
        if (!actualSubjects.isEmpty()) {
            this.passiveComplement = new PPPhraseSpec(Constants.PASSIVE_VON);
            for (Phrase p : actualSubjects) {
                p.setDiscourseFunction(DiscourseFunction.PREP_OBJECT);
                this.passiveComplement.addComplement(p);
            }
        }
    }

    void buildPassiveInterrogativeComplement() {
        PPPhraseSpec pic = new PPPhraseSpec(Constants.PASSIVE_VON);
        NPPhraseSpec inp = new NPPhraseSpec(Constants.getInterrogative(this.interrogType));
        pic.setComplement(inp);
        this.interrogType = InterrogativeType.WH_ELEMENT;
        this.addModifier(Position.FRONT, pic);
    }

    List<Phrase> getNonElidedSubjects() {
        ArrayList<Phrase> subjects = new ArrayList<Phrase>();
        for (Phrase p : this.getComplements(DiscourseFunction.SUBJECT)) {
            if (p.isElided()) continue;
            subjects.add(p);
        }
        return subjects;
    }

    boolean isBeVerb(String verb) {
        boolean beVerb = false;
        if (verb != null) {
            beVerb = verb.equalsIgnoreCase("be") || verb.equalsIgnoreCase("am") || verb.equalsIgnoreCase("are") || verb.equalsIgnoreCase("is") || verb.equalsIgnoreCase("was") || verb.equalsIgnoreCase("were");
        }
        return beVerb;
    }

    Verb castToVerb(String verb) {
        Verb v = this.isBeVerb(verb) ? new Verb("be") : new Verb(verb);
        return v;
    }

    List<Phrase> flagRaisedNPs(List<Phrase> flagged, boolean raise) {
        for (Phrase p : flagged) {
            if (!(p instanceof NPPhraseSpec)) continue;
            ((NPPhraseSpec)p).setRaised(raise);
        }
        return flagged;
    }

    boolean hasEmbeddedVP() {
        for (Phrase p : this.complements) {
            if (!(p instanceof VPPhraseSpec)) continue;
            return true;
        }
        return false;
    }
}

