/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import java.util.List;
import simplenlg.exception.SimplenlgException;
import simplenlg.formatter.Formatter;
import simplenlg.formatter.HTMLFormatter;
import simplenlg.formatter.TextFormatter;
import simplenlg.lexicon.Lexicon;
import simplenlg.lexicon.LexiconInterface;
import simplenlg.realiser.DocStructure;
import simplenlg.realiser.PhraseSpec;
import simplenlg.realiser.Spec;

public class Realiser {
    private boolean HTML = false;
    private int lineLength = 70;
    private LexiconInterface lexicon;
    private Formatter formatter;
    private static final String FOLLOW_NOSPACE = " (";
    private static final String START_NOSPACE = " ;,.!?)";
    private static final String PUNCTUATION = "!?.:;-,";
    static final String SENTENCE_TERMINATORS = "!?.";

    public Realiser() {
        this(new Lexicon());
    }

    public Realiser(LexiconInterface lexicon) {
        this.lexicon = lexicon;
        this.formatter = new TextFormatter();
    }

    public LexiconInterface getLexicon() {
        return this.lexicon;
    }

    public boolean isHTML() {
        return this.HTML;
    }

    public void setHTML(boolean html) {
        this.HTML = html;
        this.formatter = html ? new HTMLFormatter() : new TextFormatter();
    }

    public void setLineLength(int lineLength) {
        this.lineLength = lineLength;
    }

    public int getLineLength() {
        return this.lineLength;
    }

    Formatter getFormatter() {
        return this.formatter;
    }

    public String realise(Object spec) {
        if (spec == null) {
            return "";
        }
        if (spec instanceof String) {
            return (String)spec;
        }
        if (spec instanceof PhraseSpec) {
            return ((PhraseSpec)spec).isElided() ? "" : ((PhraseSpec)spec).realise(this);
        }
        if (spec instanceof Spec) {
            return ((Spec)spec).realise(this);
        }
        throw new SimplenlgException("Can only realise Strings or Specs");
    }

    public String realiseDocument(Spec spec) {
        return this.realise(spec.promote(DocStructure.DOCUMENT));
    }

    String applySentenceOrthography(String body) {
        return this.applySentenceOrthography(body, '.', true);
    }

    String applySentenceOrthography(String body, char terminator, boolean capitalise) {
        if (body.length() == 0) {
            return body;
        }
        String result = body.trim();
        char firstChar = result.charAt(0);
        if (capitalise && Character.isLetter(firstChar) && Character.isLowerCase(firstChar)) {
            result = Character.toUpperCase(firstChar) + result.substring(1);
        }
        result = this.addPunctuation(result, terminator);
        return result;
    }

    String applyParagraphOrthography(String body) {
        String result = this.pour(body, this.lineLength);
        return result;
    }

    String applyDocumentOrthography(String body) {
        String result = body;
        while (result.startsWith(this.formatter.getNEW_LINE())) {
            result = result.substring(this.formatter.getNEW_LINE().length());
        }
        return result;
    }

    String appendSpace(String ... strings) {
        String result = "";
        for (String s : strings) {
            if (s == null) continue;
            if (result.length() == 0) {
                result = s;
                continue;
            }
            if (s == null) continue;
            result = this.spaceNeeded(result, s) ? result + " " + s : result + s;
        }
        return result;
    }

    String appendSpace(String body, char c) {
        return this.appendSpace(body, Character.toString(c));
    }

    private boolean spaceNeeded(String firstString, String secondString) {
        if (firstString == null || secondString == null || firstString.length() == 0 | secondString.length() == 0) {
            return false;
        }
        char lastChar = firstString.charAt(firstString.length() - 1);
        if (Character.isWhitespace(lastChar) || FOLLOW_NOSPACE.indexOf(lastChar) >= 0) {
            return false;
        }
        char firstChar = secondString.charAt(0);
        return !Character.isWhitespace(firstChar) && START_NOSPACE.indexOf(firstChar) < 0;
    }

    String realiseList(List elements) {
        String realisation = null;
        realisation = elements == null || elements.isEmpty() ? "" : (elements.size() == 1 ? this.realise(elements.get(0)) : this.appendSpace(this.realise(elements.get(0)), this.realiseList(elements.subList(1, elements.size()))));
        return realisation == null ? "" : realisation;
    }

    String realiseIndentedList(List<Spec> elements) {
        if (elements == null || elements.isEmpty()) {
            return "";
        }
        String result = "";
        for (Spec spec : elements) {
            result = result + this.formatter.addListElementMarkup(this.realise(spec));
        }
        return this.formatter.addIndentedListMarkup(result);
    }

    protected String realiseConjunctList(List elements, String conjunct) {
        if (elements == null) {
            return "";
        }
        switch (elements.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return this.realise(elements.get(0));
            }
            case 2: {
                return this.appendSpace(this.realise(elements.get(0)), conjunct, this.realise(elements.get(1)));
            }
        }
        String[] strings = new String[elements.size()];
        char separator = ',';
        int index = 0;
        for (Object e : elements) {
            String s = this.realise(e);
            if (s.contains(",") || s.contains(";")) {
                separator = ';';
            }
            strings[index] = s;
            ++index;
        }
        String result = strings[0];
        for (index = 1; index < strings.length - 1; ++index) {
            result = this.appendSpace(this.addPunctuation(result, separator), strings[index]);
        }
        return this.appendSpace(result, conjunct, strings[strings.length - 1]);
    }

    protected String realiseCommaConjunctList(List elements, String conjunct) {
        if (elements == null) {
            return "";
        }
        if (elements.size() == 2) {
            return this.appendSpace(this.realise(elements.get(0)), ",", conjunct, this.realise(elements.get(1)));
        }
        return this.realiseConjunctList(elements, conjunct);
    }

    String realiseAndList(List elements) {
        return this.realiseConjunctList(elements, "und");
    }

    private String addPunctuation(String body, char punctuation) {
        char lastChar = body.charAt(body.length() - 1);
        if (PUNCTUATION.indexOf(lastChar) < 0) {
            return this.appendSpace(body, punctuation);
        }
        if (PUNCTUATION.indexOf(lastChar) <= PUNCTUATION.indexOf(punctuation)) {
            return body;
        }
        return this.appendSpace(body.substring(0, body.length() - 1), punctuation);
    }

    private String pour(String body, int length) {
        if (body.length() <= length) {
            return body;
        }
        for (int i = length; i > 0; --i) {
            if (!Character.isWhitespace(body.charAt(i))) continue;
            return body.substring(0, i) + this.formatter.getNEW_LINE() + this.pour(body.substring(i + 1), length);
        }
        return body;
    }
}

