/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import simplenlg.features.DiscourseFunction;
import simplenlg.lexicon.lexicalitems.LexicalItem;
import simplenlg.realiser.DocStructure;
import simplenlg.realiser.Phrase;
import simplenlg.realiser.PhraseSpec;
import simplenlg.realiser.Realiser;
import simplenlg.realiser.SPhraseSpec;
import simplenlg.realiser.TextSpec;
import simplenlg.realiser.comparators.PhraseComparator;

public abstract class HeadedPhraseSpec<T extends LexicalItem>
extends PhraseSpec {
    protected T head = null;
    protected List<Phrase> complements = new ArrayList<Phrase>();
    protected List<Phrase> premodifiers = new ArrayList<Phrase>();
    protected List<Phrase> postmodifiers = new ArrayList<Phrase>();
    protected List<Phrase> attributiveModifiers = new ArrayList<Phrase>();
    protected boolean negated;
    Comparator<Phrase> complementComparator;
    Comparator<Phrase> premodifierComparator;
    Comparator<Phrase> postmodifierComparator;

    public HeadedPhraseSpec() {
        this.category = null;
        this.complementComparator = PhraseComparator.defaultInstance();
        this.premodifierComparator = null;
        this.postmodifierComparator = PhraseComparator.defaultInstance();
    }

    public HeadedPhraseSpec(T head) {
        this();
        this.head = head;
    }

    public T getHead() {
        return this.head;
    }

    public void setHead(T head) {
        this.head = head;
    }

    public String getHeadAsString() {
        return this.head == null ? null : this.head.getBaseForm();
    }

    public void setComplementOrder(Comparator<Phrase> comp) {
        this.complementComparator = comp;
    }

    public void setPremodifierOrder(Comparator<Phrase> comp) {
        this.premodifierComparator = comp;
    }

    public void setPostmodifierOrder(Comparator<Phrase> comp) {
        this.postmodifierComparator = comp;
    }

    public void setComplement(Object comp) {
        this.complements.clear();
        this.addComplement(comp);
    }

    public void addComplement(Object comp) {
        Phrase complement = this.makeConstituent(comp, DiscourseFunction.OBJECT);
        this.complements.add(complement);
    }

    public void setPremodifier(Object mod) {
        this.premodifiers.clear();
        this.addPremodifier(mod);
    }

    public void addPremodifier(Object mod) {
        this.premodifiers.add(this.makeConstituent(mod, DiscourseFunction.PREMODIFIER));
    }

    public void setPostmodifier(Object mod) {
        this.postmodifiers.clear();
        this.addPostmodifier(mod);
    }

    public void addPostmodifier(Object mod) {
        this.postmodifiers.add(this.makeConstituent(mod, DiscourseFunction.POSTMODIFIER));
    }

    public void addAttributivePostmodifier(Object mod) {
        this.attributiveModifiers.add(this.makeConstituent(mod, DiscourseFunction.POSTMODIFIER));
    }

    public boolean hasComplements() {
        return !this.complements.isEmpty();
    }

    public boolean hasPremodifiers() {
        return !this.premodifiers.isEmpty();
    }

    public boolean hasPostmodifiers() {
        return !this.postmodifiers.isEmpty();
    }

    public boolean hasAttributivePostmodifiers() {
        return !this.attributiveModifiers.isEmpty();
    }

    public List<Phrase> getComplements() {
        return this.complements;
    }

    public List<Phrase> getPremodifiers() {
        return this.premodifiers;
    }

    public List<Phrase> getPostmodifiers() {
        return this.postmodifiers;
    }

    public List<Phrase> getAttributivePostmodifiers() {
        return this.attributiveModifiers;
    }

    public void addModifier(Object modifier) {
        if (modifier instanceof String) {
            this.addPostmodifier(modifier);
        } else if (modifier instanceof SPhraseSpec) {
            this.addAttributivePostmodifier(modifier);
        } else {
            this.addPostmodifier(modifier);
        }
    }

    public boolean hasHead() {
        return this.head != null;
    }

    @Override
    public TextSpec promote(DocStructure level) {
        return new TextSpec(new Object[]{level, this});
    }

    public void setNegated(boolean neg) {
        this.negated = neg;
    }

    public boolean isNegated() {
        return this.negated;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        try {
            HeadedPhraseSpec hps = (HeadedPhraseSpec)o;
            return this.sameHead(hps) && hps.premodifiers.equals(this.premodifiers) && hps.complements.equals(this.complements) && hps.postmodifiers.equals(this.postmodifiers) && hps.attributiveModifiers.equals(this.attributiveModifiers);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    @Override
    String realise(Realiser r) {
        return r.appendSpace(this.realisePremodifier(r), this.realiseHead(r), this.realiseComplement(r), this.realisePostmodifier(r));
    }

    String realisePremodifier(Realiser r) {
        String pre;
        if (this.premodifierComparator != null) {
            Collections.sort(this.premodifiers, this.premodifierComparator);
        }
        return (pre = r.realiseList(this.premodifiers)) == null ? "" : pre;
    }

    String realisePostmodifier(Realiser r) {
        if (this.postmodifierComparator != null) {
            Collections.sort(this.postmodifiers, this.postmodifierComparator);
            Collections.sort(this.attributiveModifiers, this.postmodifierComparator);
        }
        String post = r.realiseList(this.postmodifiers);
        String post2 = r.realiseList(this.attributiveModifiers);
        if (post2 != null && post2.length() > 0) {
            StringBuilder builder = post == null ? new StringBuilder() : new StringBuilder(post);
            post = builder.append(", ").append(post2).append(", ").toString();
        }
        return post == null ? "" : post;
    }

    String realiseComplement(Realiser r) {
        String comp = r.realiseAndList(this.complements);
        return comp == null ? "" : comp;
    }

    String realiseHead(Realiser r) {
        return this.head == null ? "" : this.head.getBaseForm();
    }

    void clearComplements() {
        this.complements.clear();
    }

    boolean sameHead(HeadedPhraseSpec<?> hps) {
        if (this.head == hps.head) {
            return true;
        }
        if (this.head == null || hps.head == null) {
            return false;
        }
        return this.head.equals(hps.head);
    }

    abstract void setHead(String var1);

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Phrase: " + (Object)((Object)this.category) + "[");
        builder.append(this.head == null ? null : this.head.getBaseForm());
        builder.append("]");
        return builder.toString();
    }
}

