/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.realiser;

import simplenlg.realiser.DocStructure;

public enum DocStructure {
    PHRASE,
    PHRASESET,
    SENTENCE,
    SENTENCESET,
    PARAGRAPH,
    PARAGRAPHSET,
    SUBSECTION,
    SECTION,
    DOCUMENT;


    public boolean isSentence() {
        return this == SENTENCE;
    }

    public boolean isParagraph() {
        return this == PARAGRAPH;
    }

    public boolean isSentenceOrLower() {
        return this.compareTo(SENTENCE) <= 0;
    }

    public boolean isSentenceComponent() {
        return this.compareTo(SENTENCE) < 0;
    }

    public DocStructure max(DocStructure d2) {
        if (this.compareTo(d2) > 0) {
            return this;
        }
        return d2;
    }

    public DocStructure next() {
        switch (1.$SwitchMap$simplenlg$realiser$DocStructure[this.ordinal()]) {
            case 1: {
                return PHRASESET;
            }
            case 2: {
                return SENTENCE;
            }
            case 3: {
                return SENTENCESET;
            }
            case 4: {
                return PARAGRAPH;
            }
            case 5: {
                return PARAGRAPHSET;
            }
            case 6: {
                return SUBSECTION;
            }
            case 7: {
                return SECTION;
            }
            case 8: {
                return DOCUMENT;
            }
            case 9: {
                return DOCUMENT;
            }
        }
        return DOCUMENT;
    }

    public DocStructure previous() {
        switch (1.$SwitchMap$simplenlg$realiser$DocStructure[this.ordinal()]) {
            case 1: {
                return PHRASE;
            }
            case 2: {
                return PHRASE;
            }
            case 3: {
                return PHRASESET;
            }
            case 4: {
                return SENTENCE;
            }
            case 5: {
                return SENTENCESET;
            }
            case 6: {
                return PARAGRAPH;
            }
            case 7: {
                return PARAGRAPHSET;
            }
            case 8: {
                return SUBSECTION;
            }
            case 9: {
                return SECTION;
            }
        }
        return PHRASE;
    }

    public DocStructure lowestParent() {
        switch (1.$SwitchMap$simplenlg$realiser$DocStructure[this.ordinal()]) {
            case 2: {
                return PHRASESET;
            }
            case 4: {
                return SENTENCESET;
            }
        }
        return this.next();
    }
}

