/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.db;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import simplenlg.features.AuxType;
import simplenlg.features.Case;
import simplenlg.features.Category;
import simplenlg.features.Gender;
import simplenlg.features.NumberAgr;
import simplenlg.lexicon.Lexicon;
import simplenlg.lexicon.lexicalitems.Adjective;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.lexicon.lexicalitems.LexicalItem;
import simplenlg.lexicon.lexicalitems.Noun;
import simplenlg.lexicon.lexicalitems.Verb;
import simplenlg.lexicon.morph.VerbInflection;
import simplenlg.lexicon.morph.VerbInflectionPattern;

public class XMLWriter43 {
    private Writer out = null;
    private Lexicon lexicon = null;

    public XMLWriter43() {
    }

    public XMLWriter43(Lexicon lex) {
        this();
        this.lexicon = lex;
    }

    public Lexicon getLexicon() {
        return this.lexicon;
    }

    public void setLexicon(Lexicon lexicon) {
        this.lexicon = lexicon;
    }

    public Writer getWriter() {
        return this.out;
    }

    public void setWriter(Writer out) {
        this.out = out;
    }

    public void saveToFile(String filename) throws IOException {
        this.out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF8"));
        try {
            this.save();
        }
        finally {
            this.out.close();
        }
    }

    public void saveToFile(File file) throws IOException {
        this.saveToFile(file.getAbsolutePath());
    }

    public void save() throws IOException {
        if (this.out == null || this.lexicon == null) {
            return;
        }
        this.out.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\" ?>\n");
        this.writeLexicon();
    }

    private void writeLexicon() throws IOException {
        this.out.write("<lexicon>\n");
        this.writeNouns();
        this.writeAdjectives();
        this.writeVerbs();
        this.out.write("</lexicon>\n");
    }

    private void writeNouns() throws IOException {
        for (LexicalItem l : this.lexicon.getItems(Category.NOUN)) {
            this.writeNoun((Noun)l);
        }
    }

    private void writeAdjectives() throws IOException {
        for (LexicalItem l : this.lexicon.getItems(Category.ADJECTIVE)) {
            this.writeAdjective((Adjective)l);
        }
    }

    private void writeVerbs() throws IOException {
        for (LexicalItem l : this.lexicon.getItems(Category.VERB)) {
            if (Constants.isConstantVerb((Verb)l)) continue;
            this.writeVerb((Verb)l);
        }
    }

    private void writeNoun(Noun n) throws IOException {
        this.out.write("<word>\n");
        this.out.write("  <base>");
        this.out.write(n.getBaseForm());
        this.out.write("</base>\n");
        this.out.write("  <category>noun</category>\n");
        this.out.write("  <id>");
        this.out.write(n.getID());
        this.out.write("</id>\n");
        this.out.write("  <gender>");
        this.out.write(XMLWriter43.getGenderString(n.getGender()));
        this.out.write("</gender>\n");
        if (n.isFixedPluralNoun()) {
            this.out.write("  <fixedplural/>\n");
        }
        if (n.isAdjectiveInflection()) {
            this.out.write("  <adjectiveinflection/>\n");
        }
        if (!n.isFixedPluralNoun() && !n.isAdjectiveInflection()) {
            if (n.isRegular()) {
                this.out.write("  <infsuffix>");
                this.out.write(n.getSuffix(Case.GENITIVE, NumberAgr.SINGULAR));
                this.out.write("::");
                this.out.write(n.getSuffix(Case.NOMINATIVE, NumberAgr.PLURAL));
                this.out.write("</infsuffix>\n");
            } else {
                this.out.write("  <inflectionnotimplemented/>\n");
            }
        }
        this.out.write("</word>\n");
    }

    private void writeNounSuffix(Noun n, Case c, NumberAgr num) throws IOException {
        String suffix = n.getSuffix(c, num);
        boolean form = false;
        if (!suffix.isEmpty() && Character.isUpperCase(suffix.charAt(0))) {
            form = true;
        }
        this.out.write(form ? "\t\t\t<form " : "\t\t\t<suffix ");
        this.out.write("case=\"");
        this.out.write(XMLWriter43.getCaseString(c));
        this.out.write("\" num=\"");
        this.out.write(XMLWriter43.getNumberString(num));
        this.out.write("\">");
        this.out.write(suffix);
        this.out.write(form ? "</form>\n" : "</suffix>\n");
    }

    private void writeAdjective(Adjective a) throws IOException {
        this.out.write("<word>\n");
        this.out.write("  <base>");
        this.out.write(a.getBaseForm());
        this.out.write("</base>\n");
        this.out.write("  <category>adjective</category>\n");
        this.out.write("  <id>");
        this.out.write(a.getID());
        this.out.write("</id>\n");
        if (a.isElideFinalE()) {
            this.out.write("  <elision/>\n");
        }
        this.out.write("  <comp>");
        this.out.write(a.getComparative());
        this.out.write("</comp>\n");
        this.out.write("  <super>");
        this.out.write(a.getSuperlative());
        this.out.write("</super>\n");
        this.out.write("</word>\n");
    }

    private void writeVerb(Verb v) throws IOException {
        VerbInflectionPattern pattern;
        this.out.write("<word>\n");
        this.out.write("  <base>");
        this.out.write(v.getBaseForm());
        this.out.write("</base>\n");
        this.out.write("  <category>verb</category>\n");
        this.out.write("  <id>");
        this.out.write(v.getID());
        this.out.write("</id>\n");
        if (v.getAuxType().equals(AuxType.SEIN)) {
            this.out.write("  <aux>sein</aux>\n");
        }
        if (!(pattern = v.getPattern()).equals(Constants.VERB_INFLECTION_DEFAULT)) {
            this.out.write("  <infpattern>");
            this.out.write(pattern.getName());
            this.out.write("</infpattern>\n");
        }
        String stem = VerbInflection.detectStem(v.getInfinitiveStem());
        String past = v.getPastStem();
        String part = v.getPerfectParticiple();
        String subj = v.getSubjunctiveStem();
        if (!past.equals(stem.concat("te")) || !part.equals("ge".concat(stem).concat("t"))) {
            this.out.write("  <paststem>");
            this.out.write(past);
            this.out.write("</paststem>\n");
            this.out.write("  <participle>");
            this.out.write(part);
            this.out.write("</participle>\n");
        }
        if (v.hasAlternatePresentStem()) {
            this.out.write("  <alt-sg>");
            this.out.write(v.getAlternatePresentStem());
            this.out.write("</alt-sg>\n");
        }
        if (!subj.equals(past)) {
            this.out.write("  <subj2>");
            this.out.write(v.getSubjunctiveStem());
            this.out.write("</subj2>\n");
        }
        this.out.write("</word>\n");
    }

    private void writeDTD() throws IOException {
        this.out.write("<!DOCTYPE Lexicon [\n");
        this.out.write("<!ELEMENT Lexicon (Nouns?, Adjectives?, Verbs?)>\n\n");
        this.out.write("<!ELEMENT Nouns (noun)*>\n");
        this.out.write("<!ELEMENT noun (stem, (suffix|form), (suffix|form)+)>\n");
        this.out.write("<!ATTLIST noun\n");
        this.out.write("  id     ID                          #REQUIRED\n");
        this.out.write("  gender (masculine|feminine|neuter) \"neuter\"\n");
        this.out.write("  fixedplural (true|false) \"false\"\n");
        this.out.write("  adjectiveflexion (true|false) \"false\"\n");
        this.out.write(">\n\n");
        this.out.write("<!ELEMENT Adjectives (adjective)*>\n");
        this.out.write("<!ELEMENT adjective (stem, comp, super)>\n");
        this.out.write("<!ATTLIST adjective\n");
        this.out.write("  id       ID            #REQUIRED\n");
        this.out.write("  elision  (true|false)  \"false\"\n");
        this.out.write(">\n\n");
        this.out.write("<!ELEMENT Verbs (verb)*>\n");
        this.out.write("<!ELEMENT verb (stem, past?, part?, alt-sg?, subj2?)>\n");
        this.out.write("<!ATTLIST verb\n");
        this.out.write("  id\t      ID            #REQUIRED\n");
        this.out.write("  aux\t      (haben|sein)  \"haben\"\n");
        this.out.write("  inflection  CDATA         #IMPLIED\n");
        this.out.write(">\n\n");
        this.out.write("<!ELEMENT stem   (#PCDATA)>\n");
        this.out.write("<!ELEMENT comp   (#PCDATA)>\n");
        this.out.write("<!ELEMENT super  (#PCDATA)>\n");
        this.out.write("<!ELEMENT past   (#PCDATA)>\n");
        this.out.write("<!ELEMENT part   (#PCDATA)>\n");
        this.out.write("<!ELEMENT alt-sg (#PCDATA)>\n");
        this.out.write("<!ELEMENT subj2  (#PCDATA)>\n");
        this.out.write("<!ELEMENT suffix (#PCDATA)>\n");
        this.out.write("<!ATTLIST suffix\n");
        this.out.write("  case  (nom|acc|gen|dat)  #REQUIRED\n");
        this.out.write("  num   (sg|pl)            #REQUIRED\n");
        this.out.write(">\n\n");
        this.out.write("<!ELEMENT form   (#PCDATA)>\n");
        this.out.write("<!ATTLIST form\n");
        this.out.write("  case  (nom|acc|gen|dat)  #REQUIRED\n");
        this.out.write("  num   (sg|pl)            #REQUIRED\n");
        this.out.write(">\n\n");
        this.out.write("]>\n\n");
    }

    public static String getGenderString(Gender g) {
        switch (g) {
            case MASCULINE: {
                return "masculine";
            }
            case FEMININE: {
                return "feminine";
            }
        }
        return "neuter";
    }

    private static String getCaseString(Case c) {
        switch (c) {
            default: {
                return "nom";
            }
            case ACCUSATIVE: {
                return "acc";
            }
            case GENITIVE: {
                return "gen";
            }
            case DATIVE: 
        }
        return "dat";
    }

    private static String getNumberString(NumberAgr num) {
        switch (num) {
            default: {
                return "sg";
            }
            case PLURAL: 
        }
        return "pl";
    }
}

