import data_handle.DataProcessing
import EAttHBiLSTM_FK

if(__name__ == "__main__"):
    numClasses = 3
    numDimensions = 200
    input_keep_prob_ = 0.5
    output_keep_prob_ = 0.5
    cross_multiple = 5
    iterations = 1000

    # wordModel = data_handle.DataProcessing.DataProcessing(
    #     'D:/SemEval2019-Task6/workspace/wordModel/glove.twitter.27B.200d.txt',
    #     'D:/SemEval2019-Task6/workspace/data/train/offenseval-training-v1.tsv',
    #     'D:/SemEval2019-Task6/workspace/wordModel/emoji2vec200.txt',
    #     'D:/SemEval2019-Task6/workspace/wordModel/SwearWord2vec.txt',
    #     numDimensions, eab=2)

    wordModel = data_handle.DataProcessing.DataProcessing(
        '/home/yjzhang_xu/workspace/WordVecModel/dataset/glove.twitter.27B.200d.txt',
        '/home/yjzhang_xu/workspace/SE2019T6WS/data/train/offenseval-training-v1.tsv',
        '/home/yjzhang_xu/workspace/WordVecModel/dataset/emoji2vec200.txt',
        '/home/yjzhang_xu/workspace/WordVecModel/dataset/SwearWord2vec.txt',
        numDimensions, eab=2)

    f1_sum = 0.
    for i in range(cross_multiple):
        f1 = EAttHBiLSTM_FK.EAttHBiLSTMRun(wordModel, numClasses, input_keep_prob_, output_keep_prob_, i, iterations)
        with open("../trained_model/log_eatthbilstm.txt", "a", encoding="utf-8") as f:
            f.write("\r\n")
            f.close()
        f1_sum += f1
    f1_sum /= 5
    with open("../trained_model/log_eatthbilstm.txt", "a", encoding="utf-8") as f:
        f.write(str(f1_sum) + "\r\n")
        f.close()
