/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.HasInterval;
import edu.stanford.nlp.util.Interval;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class IntervalTree<E extends Comparable<E>, T extends HasInterval<E>> {
    T value;
    E maxEnd;
    int size;
    IntervalTree<E, T> left;
    IntervalTree<E, T> right;

    public boolean isEmpty() {
        return this.value == null;
    }

    public void addAll(Collection<T> c) {
        for (HasInterval t : c) {
            this.add(t);
        }
    }

    public void add(T target) {
        if (target == null) {
            return;
        }
        if (this.value == null) {
            this.value = target;
            this.maxEnd = target.getInterval().getEnd();
            this.size = 1;
        } else {
            this.maxEnd = Interval.max(this.maxEnd, target.getInterval().getEnd());
            ++this.size;
            if (target.getInterval().getBegin().compareTo(this.value.getInterval().getBegin()) <= 0) {
                if (this.left == null) {
                    this.left = new IntervalTree<E, T>();
                }
                this.left.add(target);
            } else {
                if (this.right == null) {
                    this.right = new IntervalTree<E, T>();
                }
                this.right.add(target);
            }
        }
    }

    public int size() {
        return this.size;
    }

    public boolean remove(T target) {
        if (target == null) {
            return false;
        }
        if (this.value == null) {
            return false;
        }
        if (target.equals(this.value)) {
            int rightSize;
            int leftSize = this.left != null ? this.left.size() : 0;
            int n = rightSize = this.right != null ? this.right.size() : 0;
            if (leftSize == 0) {
                if (rightSize == 0) {
                    this.value = null;
                    this.size = 0;
                } else {
                    this.value = this.right.value;
                    this.size = this.right.size;
                    this.maxEnd = this.right.maxEnd;
                    this.left = this.right.left;
                    this.right = this.right.right;
                }
            } else if (rightSize == 0) {
                this.value = this.left.value;
                this.size = this.left.size;
                this.maxEnd = this.left.maxEnd;
                this.left = this.left.left;
                this.right = this.left.right;
            } else {
                this.value = this.left.value;
                --this.size;
                this.maxEnd = Interval.max(this.left.maxEnd, this.right.maxEnd);
                IntervalTree<E, T> origRight = this.right;
                this.right = this.left.right;
                this.left = this.left.left;
                IntervalTree<E, T> rightmost = this.getRightmostNode();
                rightmost.right = origRight;
            }
            return true;
        }
        if (target.getInterval().getBegin().compareTo(this.value.getInterval().getBegin()) <= 0) {
            if (this.left == null) {
                return false;
            }
            boolean res = this.left.remove(target);
            if (res) {
                this.maxEnd = Interval.max(this.maxEnd, this.left.maxEnd);
                --this.size;
            }
            return res;
        }
        if (this.right == null) {
            return false;
        }
        boolean res = this.right.remove(target);
        if (res) {
            this.maxEnd = Interval.max(this.maxEnd, this.right.maxEnd);
            --this.size;
        }
        return res;
    }

    public IntervalTree<E, T> getLeftmostNode() {
        if (this.left == null) {
            return this;
        }
        return this.left.getLeftmostNode();
    }

    public IntervalTree<E, T> getRightmostNode() {
        if (this.right == null) {
            return this;
        }
        return this.right.getRightmostNode();
    }

    public boolean addNonOverlapping(T target) {
        if (this.overlaps(target)) {
            return false;
        }
        this.add(target);
        return true;
    }

    public boolean addNonNested(T target) {
        if (this.contains(target)) {
            return false;
        }
        this.add(target);
        return true;
    }

    public boolean overlaps(T target) {
        return IntervalTree.overlaps(this, target.getInterval());
    }

    public List<T> getOverlapping(T target) {
        return IntervalTree.getOverlapping(this, target.getInterval());
    }

    public static <E extends Comparable<E>, T extends HasInterval<E>> List<T> getOverlapping(IntervalTree<E, T> n, E p) {
        ArrayList overlapping = new ArrayList();
        IntervalTree.getOverlapping(n, p, overlapping);
        return overlapping;
    }

    public static <E extends Comparable<E>, T extends HasInterval<E>> List<T> getOverlapping(IntervalTree<E, T> n, Interval<E> target) {
        ArrayList overlapping = new ArrayList();
        IntervalTree.getOverlapping(n, target, overlapping);
        return overlapping;
    }

    public static <E extends Comparable<E>, T extends HasInterval<E>> void getOverlapping(IntervalTree<E, T> n, E p, List<T> result) {
        IntervalTree.getOverlapping(n, Interval.toInterval(p, p), result);
    }

    public static <E extends Comparable<E>, T extends HasInterval<E>> void getOverlapping(IntervalTree<E, T> n, Interval<E> target, List<T> result) {
        if (n == null || n.isEmpty()) {
            return;
        }
        if (((Comparable)target.first).compareTo(n.maxEnd) > 0) {
            return;
        }
        if (n.left != null) {
            IntervalTree.getOverlapping(n.left, target, result);
        }
        if (n.value.getInterval().overlaps(target)) {
            result.add(n.value);
        }
        if (((Comparable)target.second).compareTo(n.value.getInterval().first()) < 0) {
            return;
        }
        if (n.right != null) {
            IntervalTree.getOverlapping(n.right, target, result);
        }
    }

    public static <E extends Comparable<E>, T extends HasInterval<E>> boolean overlaps(IntervalTree<E, T> n, E p) {
        return IntervalTree.overlaps(n, Interval.toInterval(p, p));
    }

    public static <E extends Comparable<E>, T extends HasInterval<E>> boolean overlaps(IntervalTree<E, T> n, Interval<E> target) {
        if (n == null || n.isEmpty()) {
            return false;
        }
        if (((Comparable)target.first).compareTo(n.maxEnd) > 0) {
            return false;
        }
        if (n.value.getInterval().overlaps(target)) {
            return true;
        }
        if (((Comparable)target.second).compareTo(n.value.getInterval().first()) <= 0) {
            if (n.left != null) {
                return IntervalTree.overlaps(n.left, target);
            }
        } else if (n.right != null) {
            return IntervalTree.overlaps(n.right, target);
        }
        return false;
    }

    public boolean contains(T target) {
        return IntervalTree.contains(this, target.getInterval());
    }

    public static <E extends Comparable<E>, T extends HasInterval<E>> boolean contains(IntervalTree<E, T> n, E p) {
        return IntervalTree.contains(n, Interval.toInterval(p, p));
    }

    public static <E extends Comparable<E>, T extends HasInterval<E>> boolean contains(IntervalTree<E, T> n, Interval<E> target) {
        if (n == null || n.isEmpty()) {
            return false;
        }
        if (((Comparable)target.first).compareTo(n.maxEnd) > 0) {
            return false;
        }
        if (n.value.getInterval().contains(target)) {
            return true;
        }
        if (((Comparable)target.second).compareTo(n.value.getInterval().first()) <= 0) {
            if (n.left != null) {
                return IntervalTree.contains(n.left, target);
            }
        } else if (n.right != null) {
            return IntervalTree.contains(n.right, target);
        }
        return false;
    }

    public static <T, E extends Comparable<E>> List<T> getNonOverlapping(List<? extends T> items, Function<? super T, Interval<E>> toIntervalFunc) {
        ArrayList<T> nonOverlapping = new ArrayList<T>();
        IntervalTree<E, Interval<E>> intervals = new IntervalTree<E, Interval<E>>();
        for (T item : items) {
            Interval<E> i = toIntervalFunc.apply(item);
            boolean addOk = intervals.addNonOverlapping(i);
            if (!addOk) continue;
            nonOverlapping.add(item);
        }
        return nonOverlapping;
    }

    public static <T, E extends Comparable<E>> List<T> getNonOverlapping(List<? extends T> items, Function<? super T, Interval<E>> toIntervalFunc, Comparator<? super T> compareFunc) {
        ArrayList<? extends T> sorted = new ArrayList<T>(items);
        Collections.sort(sorted, compareFunc);
        return IntervalTree.getNonOverlapping(sorted, toIntervalFunc);
    }

    public static <T extends HasInterval<E>, E extends Comparable<E>> List<T> getNonOverlapping(List<? extends T> items, Comparator<? super T> compareFunc) {
        Function toIntervalFunc = new Function<T, Interval<E>>(){

            @Override
            public Interval<E> apply(T in) {
                return in.getInterval();
            }
        };
        return IntervalTree.getNonOverlapping(items, toIntervalFunc, compareFunc);
    }

    public static <T extends HasInterval<E>, E extends Comparable<E>> List<T> getNonOverlapping(List<? extends T> items) {
        Function toIntervalFunc = new Function<T, Interval<E>>(){

            @Override
            public Interval<E> apply(T in) {
                return in.getInterval();
            }
        };
        return IntervalTree.getNonOverlapping(items, toIntervalFunc);
    }

    public static <T, E extends Comparable<E>> List<T> getNonNested(List<? extends T> items, Function<? super T, Interval<E>> toIntervalFunc, Comparator<? super T> compareFunc) {
        ArrayList<T> sorted = new ArrayList<T>(items);
        Collections.sort(sorted, compareFunc);
        ArrayList res = new ArrayList();
        IntervalTree<E, Interval<E>> intervals = new IntervalTree<E, Interval<E>>();
        for (Object item : sorted) {
            Interval<E> i = toIntervalFunc.apply(item);
            boolean addOk = intervals.addNonNested(i);
            if (!addOk) continue;
            res.add(item);
        }
        return res;
    }
}

