/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.StringUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Properties;

public class TaggerConfig
extends Properties {
    private static final long serialVersionUID = -4136407850147157497L;
    public static final String SEARCH = "qn";
    public static final String TAG_SEPARATOR = "/";
    public static final String TOKENIZE = "true";
    public static final String DEBUG = "false";
    public static final String ITERATIONS = "100";
    public static final String ARCH = "";
    public static final String WORD_FUNCTION = "";
    public static final String RARE_WORD_THRESH = "5";
    public static final String MIN_FEATURE_THRESH = "5";
    public static final String CUR_WORD_MIN_FEATURE_THRESH = "2";
    public static final String RARE_WORD_MIN_FEATURE_THRESH = "10";
    public static final String VERY_COMMON_WORD_THRESH = "250";
    public static final String OCCURRING_TAGS_ONLY = "false";
    public static final String POSSIBLE_TAGS_ONLY = "false";
    public static final String SIGMA_SQUARED = String.valueOf(0.5);
    public static final String ENCODING = "UTF-8";
    public static final String LEARN_CLOSED_CLASS = "false";
    public static final String CLOSED_CLASS_THRESHOLD = "40";
    public static final String VERBOSE = "false";
    public static final String VERBOSE_RESULTS = "true";
    public static final String SGML = "false";
    public static final String LANG = "";
    public static final String TOKENIZER_FACTORY = "";
    public static final String XML_INPUT = "";
    public static final String TAG_INSIDE = "";
    public static final String APPROXIMATE = "-1.0";
    public static final String TOKENIZER_OPTIONS = "";
    public static final String DEFAULT_REG_L1 = "1.0";
    public static final String OUTPUT_FILE = "";
    public static final String OUTPUT_FORMAT = "slashTags";
    public static final String OUTPUT_FORMAT_OPTIONS = "";
    public static final String NTHREADS = "1";
    public static final String ENCODING_PROPERTY = "encoding";
    public static final String TAG_SEPARATOR_PROPERTY = "tagSeparator";
    private static final Map<String, String> defaultValues = Generics.newHashMap();

    private TaggerConfig() {
        this.putAll(defaultValues);
    }

    public TaggerConfig(TaggerConfig old) {
        super(old);
    }

    public TaggerConfig(String ... args) {
        this(StringUtils.argsToProperties(args));
    }

    public TaggerConfig(Properties props) {
        this();
        if (!props.containsKey("trainFile")) {
            String name = props.getProperty("model");
            if (name == null) {
                name = props.getProperty("dump");
            }
            if (name != null) {
                try {
                    System.err.println("Loading default properties from tagger " + name);
                    DataInputStream in = new DataInputStream(IOUtils.getInputStreamFromURLOrClasspathOrFileSystem(name));
                    this.putAll((Map<?, ?>)TaggerConfig.readConfig(in));
                    in.close();
                }
                catch (Exception e) {
                    throw new RuntimeIOException("No such trained tagger config file found: " + name);
                }
            }
        }
        this.setProperties(props);
    }

    public void setProperties(Properties props) {
        if (props.getProperty("") != null) {
            throw new RuntimeException("unknown argument(s): \"" + props.getProperty("") + '\"');
        }
        if (props.getProperty("genprops") != null) {
            TaggerConfig.printGenProps(System.out);
            System.exit(0);
        }
        if (props.containsKey("mode") && props.containsKey("file")) {
            this.setProperty("mode", props.getProperty("mode"));
            this.setProperty("file", props.getProperty("file"));
        } else if (props.containsKey("trainFile")) {
            this.setProperty("mode", Mode.TRAIN.toString());
            this.setProperty("file", props.getProperty("trainFile", "").trim());
        } else if (props.containsKey("testFile")) {
            this.setProperty("mode", Mode.TEST.toString());
            this.setProperty("file", props.getProperty("testFile", "").trim());
        } else if (props.containsKey("textFile")) {
            this.setProperty("mode", Mode.TAG.toString());
            this.setProperty("file", props.getProperty("textFile", "").trim());
        } else if (props.containsKey("dump")) {
            this.setProperty("mode", Mode.DUMP.toString());
            props.setProperty("model", props.getProperty("dump").trim());
        } else {
            this.setProperty("mode", Mode.TAG.toString());
            this.setProperty("file", "stdin");
        }
        this.setProperty("model", props.getProperty("model", this.getProperty("model", "")).trim());
        if (this.getMode() != Mode.DUMP && this.getProperty("model").equals("")) {
            throw new RuntimeException("'model' parameter must be specified");
        }
        this.setProperty("search", props.getProperty("search", this.getProperty("search")).trim().toLowerCase());
        String srch = this.getProperty("search");
        if (!(srch.equals("cg") || srch.equals("iis") || srch.equals("owlqn") || srch.equals(SEARCH) || srch.equals("owlqn2"))) {
            throw new RuntimeException("'search' must be one of 'iis', 'cg', 'qn' or 'owlqn' or 'owlqn2': " + srch);
        }
        this.setProperty("sigmaSquared", props.getProperty("sigmaSquared", this.getProperty("sigmaSquared")));
        this.setProperty(TAG_SEPARATOR_PROPERTY, props.getProperty(TAG_SEPARATOR_PROPERTY, this.getProperty(TAG_SEPARATOR_PROPERTY)));
        this.setProperty("iterations", props.getProperty("iterations", this.getProperty("iterations")));
        this.setProperty("rareWordThresh", props.getProperty("rareWordThresh", this.getProperty("rareWordThresh")));
        this.setProperty("minFeatureThresh", props.getProperty("minFeatureThresh", this.getProperty("minFeatureThresh")));
        this.setProperty("curWordMinFeatureThresh", props.getProperty("curWordMinFeatureThresh", this.getProperty("curWordMinFeatureThresh")));
        this.setProperty("rareWordMinFeatureThresh", props.getProperty("rareWordMinFeatureThresh", this.getProperty("rareWordMinFeatureThresh")));
        this.setProperty("veryCommonWordThresh", props.getProperty("veryCommonWordThresh", this.getProperty("veryCommonWordThresh")));
        this.setProperty("occurringTagsOnly", props.getProperty("occurringTagsOnly", this.getProperty("occurringTagsOnly", "false")));
        this.setProperty("possibleTagsOnly", props.getProperty("possibleTagsOnly", this.getProperty("possibleTagsOnly")));
        this.setProperty("lang", props.getProperty("lang", this.getProperty("lang")));
        this.setProperty("openClassTags", props.getProperty("openClassTags", this.getProperty("openClassTags")).trim());
        this.setProperty("closedClassTags", props.getProperty("closedClassTags", this.getProperty("closedClassTags")).trim());
        this.setProperty("learnClosedClassTags", props.getProperty("learnClosedClassTags", this.getProperty("learnClosedClassTags")));
        this.setProperty("closedClassTagThreshold", props.getProperty("closedClassTagThreshold", this.getProperty("closedClassTagThreshold")));
        this.setProperty("arch", props.getProperty("arch", this.getProperty("arch")));
        if (this.getMode() == Mode.TRAIN && this.getProperty("arch").equals("")) {
            throw new IllegalArgumentException("No architecture specified; set the -arch flag with the features to be used");
        }
        this.setProperty("wordFunction", props.getProperty("wordFunction", this.getProperty("wordFunction", "")));
        this.setProperty("tokenize", props.getProperty("tokenize", this.getProperty("tokenize")));
        this.setProperty("tokenizerFactory", props.getProperty("tokenizerFactory", this.getProperty("tokenizerFactory")));
        this.setProperty("debugPrefix", props.getProperty("debugPrefix", this.getProperty("debugPrefix", "")));
        this.setProperty("debug", props.getProperty("debug", "false"));
        this.setProperty(ENCODING_PROPERTY, props.getProperty(ENCODING_PROPERTY, this.getProperty(ENCODING_PROPERTY)));
        this.setProperty("sgml", props.getProperty("sgml", this.getProperty("sgml")));
        this.setProperty("verbose", props.getProperty("verbose", this.getProperty("verbose")));
        this.setProperty("verboseResults", props.getProperty("verboseResults", this.getProperty("verboseResults")));
        this.setProperty("regL1", props.getProperty("regL1", this.getProperty("regL1")));
        this.setProperty("xmlInput", props.getProperty("xmlInput", this.getProperty("xmlInput")).trim());
        this.setProperty("tagInside", props.getProperty("tagInside", this.getProperty("tagInside")));
        this.setProperty("approximate", props.getProperty("approximate", this.getProperty("approximate")));
        this.setProperty("tokenizerOptions", props.getProperty("tokenizerOptions", this.getProperty("tokenizerOptions")));
        this.setProperty("outputFile", props.getProperty("outputFile", this.getProperty("outputFile")).trim());
        this.setProperty("outputFormat", props.getProperty("outputFormat", this.getProperty("outputFormat")).trim());
        this.setProperty("outputFormatOptions", props.getProperty("outputFormatOptions", this.getProperty("outputFormatOptions")).trim());
        this.setProperty("nthreads", props.getProperty("nthreads", this.getProperty("nthreads", NTHREADS)).trim());
        String sentenceDelimiter = props.getProperty("sentenceDelimiter", this.getProperty("sentenceDelimiter"));
        if (sentenceDelimiter != null) {
            this.setProperty("sentenceDelimiter", sentenceDelimiter);
        }
    }

    public String getModel() {
        return this.getProperty("model");
    }

    public String getFile() {
        return this.getProperty("file");
    }

    public String getOutputFile() {
        return this.getProperty("outputFile");
    }

    public String getOutputFormat() {
        return this.getProperty("outputFormat");
    }

    public String[] getOutputOptions() {
        return this.getProperty("outputFormatOptions").split("\\s*,\\s*");
    }

    public boolean getOutputVerbosity() {
        return this.getOutputOptionsContains("verbose");
    }

    public boolean getOutputLemmas() {
        return this.getOutputOptionsContains("lemmatize");
    }

    public boolean getOutputOptionsContains(String sought) {
        String[] options;
        for (String option : options = this.getOutputOptions()) {
            if (!option.equals(sought)) continue;
            return true;
        }
        return false;
    }

    public String getSearch() {
        return this.getProperty("search");
    }

    public double getSigmaSquared() {
        return Double.parseDouble(this.getProperty("sigmaSquared"));
    }

    public int getIterations() {
        return Integer.parseInt(this.getProperty("iterations"));
    }

    public int getRareWordThresh() {
        return Integer.parseInt(this.getProperty("rareWordThresh"));
    }

    public int getMinFeatureThresh() {
        return Integer.parseInt(this.getProperty("minFeatureThresh"));
    }

    public int getCurWordMinFeatureThresh() {
        return Integer.parseInt(this.getProperty("curWordMinFeatureThresh"));
    }

    public int getRareWordMinFeatureThresh() {
        return Integer.parseInt(this.getProperty("rareWordMinFeatureThresh"));
    }

    public int getVeryCommonWordThresh() {
        return Integer.parseInt(this.getProperty("veryCommonWordThresh"));
    }

    public boolean occurringTagsOnly() {
        return Boolean.parseBoolean(this.getProperty("occurringTagsOnly"));
    }

    public boolean possibleTagsOnly() {
        return Boolean.parseBoolean(this.getProperty("possibleTagsOnly"));
    }

    public String getLang() {
        return this.getProperty("lang");
    }

    public String[] getOpenClassTags() {
        return TaggerConfig.wsvStringToStringArray(this.getProperty("openClassTags"));
    }

    public String[] getClosedClassTags() {
        return TaggerConfig.wsvStringToStringArray(this.getProperty("closedClassTags"));
    }

    private static String[] wsvStringToStringArray(String str) {
        if (str == null || str.equals("")) {
            return StringUtils.EMPTY_STRING_ARRAY;
        }
        return str.split("\\s+");
    }

    public boolean getLearnClosedClassTags() {
        return Boolean.parseBoolean(this.getProperty("learnClosedClassTags"));
    }

    public int getClosedTagThreshold() {
        return Integer.parseInt(this.getProperty("closedClassTagThreshold"));
    }

    public String getArch() {
        return this.getProperty("arch");
    }

    public String getWordFunction() {
        return this.getProperty("wordFunction");
    }

    public boolean getDebug() {
        return Boolean.parseBoolean(this.getProperty("debug"));
    }

    public String getDebugPrefix() {
        return this.getProperty("debugPrefix");
    }

    public String getTokenizerFactory() {
        return this.getProperty("tokenizerFactory");
    }

    public static String getDefaultTagSeparator() {
        return TAG_SEPARATOR;
    }

    public final String getTagSeparator() {
        return this.getProperty(TAG_SEPARATOR_PROPERTY);
    }

    public boolean getTokenize() {
        return Boolean.parseBoolean(this.getProperty("tokenize"));
    }

    public String getEncoding() {
        return this.getProperty(ENCODING_PROPERTY);
    }

    public double getRegL1() {
        return Double.parseDouble(this.getProperty("regL1"));
    }

    public String[] getXMLInput() {
        return TaggerConfig.wsvStringToStringArray(this.getProperty("xmlInput"));
    }

    public boolean getVerbose() {
        return Boolean.parseBoolean(this.getProperty("verbose"));
    }

    public boolean getVerboseResults() {
        return Boolean.parseBoolean(this.getProperty("verboseResults"));
    }

    public boolean getSGML() {
        return Boolean.parseBoolean(this.getProperty("sgml"));
    }

    public int getNThreads() {
        return Integer.parseInt(this.getProperty("nthreads"));
    }

    public String getTagInside() {
        String str = this.getProperty("tagInside");
        if (str == null) {
            return "";
        }
        return str;
    }

    public String getTokenizerOptions() {
        return this.getProperty("tokenizerOptions");
    }

    public boolean getTokenizerInvertible() {
        String tokenizerOptions = this.getTokenizerOptions();
        if (tokenizerOptions != null && tokenizerOptions.matches("(^|.*,)invertible=true")) {
            return true;
        }
        return this.getOutputVerbosity() || this.getOutputLemmas();
    }

    public double getDefaultScore() {
        String approx = this.getProperty("approximate");
        if ("false".equalsIgnoreCase(approx)) {
            return -1.0;
        }
        if ("true".equalsIgnoreCase(approx)) {
            return 1.0;
        }
        return Double.parseDouble(approx);
    }

    public void dump() {
        this.dump(new PrintWriter(System.err));
    }

    public void dump(PrintStream stream) {
        PrintWriter pw = new PrintWriter(stream);
        this.dump(pw);
    }

    private void dump(PrintWriter pw) {
        pw.println("                   model = " + this.getProperty("model"));
        pw.println("                    arch = " + this.getProperty("arch"));
        pw.println("            wordFunction = " + this.getProperty("wordFunction"));
        if (this.getMode() == Mode.TRAIN || this.getMode() == Mode.DUMP) {
            pw.println("               trainFile = " + this.getProperty("file"));
        } else if (this.getMode() == Mode.TAG) {
            pw.println("                textFile = " + this.getProperty("file"));
        } else if (this.getMode() == Mode.TEST) {
            pw.println("                testFile = " + this.getProperty("file"));
        }
        pw.println("         closedClassTags = " + this.getProperty("closedClassTags"));
        pw.println(" closedClassTagThreshold = " + this.getProperty("closedClassTagThreshold"));
        pw.println(" curWordMinFeatureThresh = " + this.getProperty("curWordMinFeatureThresh"));
        pw.println("                   debug = " + this.getProperty("debug"));
        pw.println("             debugPrefix = " + this.getProperty("debugPrefix"));
        pw.println("            tagSeparator = " + this.getProperty(TAG_SEPARATOR_PROPERTY));
        pw.println("                encoding = " + this.getProperty(ENCODING_PROPERTY));
        pw.println("              iterations = " + this.getProperty("iterations"));
        pw.println("                    lang = " + this.getProperty("lang"));
        pw.println("    learnClosedClassTags = " + this.getProperty("learnClosedClassTags"));
        pw.println("        minFeatureThresh = " + this.getProperty("minFeatureThresh"));
        pw.println("           openClassTags = " + this.getProperty("openClassTags"));
        pw.println("rareWordMinFeatureThresh = " + this.getProperty("rareWordMinFeatureThresh"));
        pw.println("          rareWordThresh = " + this.getProperty("rareWordThresh"));
        pw.println("                  search = " + this.getProperty("search"));
        pw.println("                    sgml = " + this.getProperty("sgml"));
        pw.println("            sigmaSquared = " + this.getProperty("sigmaSquared"));
        pw.println("                   regL1 = " + this.getProperty("regL1"));
        pw.println("               tagInside = " + this.getProperty("tagInside"));
        pw.println("                tokenize = " + this.getProperty("tokenize"));
        pw.println("        tokenizerFactory = " + this.getProperty("tokenizerFactory"));
        pw.println("        tokenizerOptions = " + this.getProperty("tokenizerOptions"));
        pw.println("                 verbose = " + this.getProperty("verbose"));
        pw.println("          verboseResults = " + this.getProperty("verboseResults"));
        pw.println("    veryCommonWordThresh = " + this.getProperty("veryCommonWordThresh"));
        pw.println("                xmlInput = " + this.getProperty("xmlInput"));
        pw.println("              outputFile = " + this.getProperty("outputFile"));
        pw.println("            outputFormat = " + this.getProperty("outputFormat"));
        pw.println("     outputFormatOptions = " + this.getProperty("outputFormatOptions"));
        pw.println("                nthreads = " + this.getProperty("nthreads"));
        pw.flush();
    }

    @Override
    public String toString() {
        StringWriter sw = new StringWriter(200);
        PrintWriter pw = new PrintWriter(sw);
        this.dump(pw);
        return sw.toString();
    }

    public String getSentenceDelimiter() {
        String delimiter = this.getProperty("sentenceDelimiter");
        if (delimiter == null && !this.getTokenize()) {
            delimiter = "\n";
        }
        return delimiter;
    }

    public boolean useStdin() {
        return this.getFile().trim().equalsIgnoreCase("stdin");
    }

    private static void printGenProps(PrintStream out2) {
        out2.println("## Sample properties file for maxent tagger. This file is used for three main");
        out2.println("## operations: training, testing, and tagging. It may also be used to dump");
        out2.println("## the contents of a model.");
        out2.println("## To train or test a model, or to tag something, run:");
        out2.println("##   java edu.stanford.nlp.tagger.maxent.MaxentTagger -prop <properties file>");
        out2.println("## Arguments can be overridden on the commandline, e.g.:");
        out2.println("##   java ....MaxentTagger -prop <properties file> -testFile /other/file ");
        out2.println();
        out2.println("# Model file name (created at train time; used at tag and test time)");
        out2.println("# (you can leave this blank and specify it on the commandline with -model)");
        out2.println("# model = ");
        out2.println();
        out2.println("# Path to file to be operated on (trained from, tested against, or tagged)");
        out2.println("# Specify -textFile <filename> to tag text in the given file, -trainFile <filename> to");
        out2.println("# to train a model using data in the given file, or -testFile <filename> to test your");
        out2.println("# model using data in the given file.  Alternatively, you may specify");
        out2.println("# -dump <filename> to dump the parameters stored in a model or ");
        out2.println("# -convertToSingleFile <filename> to save an old, multi-file model (specified as -model)");
        out2.println("# to the new single file format.  The new model will be saved in the file filename.");
        out2.println("# If you choose to convert an old file, you must specify ");
        out2.println("# the correct 'arch' parameter used to create the original model.");
        out2.println("# trainFile = ");
        out2.println();
        out2.println("# Path to outputFile to write tagged output to.");
        out2.println("# If empty, stdout is used.");
        out2.println("# outputFile = ");
        out2.println();
        out2.println("# Output format. One of: slashTags (default), xml, or tsv");
        out2.println("# outputFormat = slashTags");
        out2.println();
        out2.println("# Output format options. Comma separated list, but");
        out2.println("# currently \"lemmatize\" is the only supported option.");
        out2.println("# outputFormatOptions = ");
        out2.println();
        out2.println("# Tag separator character that separates word and pos tags");
        out2.println("# (for both training and test data) and used for");
        out2.println("# separating words and tags in slashTags format output.");
        out2.println("# tagSeparator = /");
        out2.println();
        out2.println("# Encoding format in which files are stored.  If left blank, UTF-8 is assumed.");
        out2.println("# encoding = UTF-8");
        out2.println();
        out2.println("# A couple flags for controlling the amount of output:");
        out2.println("# - print extra debugging information:");
        out2.println("# verbose = false");
        out2.println("# - print intermediate results:");
        out2.println("# verboseResults = true");
        out2.println("######### parameters for tag and test operations #########");
        out2.println();
        out2.println("# Class to use for tokenization. Default blank value means Penn Treebank");
        out2.println("# tokenization.  If you'd like to just assume that tokenization has been done,");
        out2.println("# and the input is whitespace-tokenized, use");
        out2.println("# edu.stanford.nlp.process.WhitespaceTokenizer or set tokenize to false.");
        out2.println("# tokenizerFactory = ");
        out2.println();
        out2.println("# Options to the tokenizer.  A comma separated list.");
        out2.println("# This depends on what the tokenizer supports.");
        out2.println("# For PTBTokenizer, you might try options like americanize=false");
        out2.println("# or asciiQuotes (for German!).");
        out2.println("# tokenizerOptions = ");
        out2.println();
        out2.println("# Whether to tokenize text for tag and test operations. Default is true.");
        out2.println("# If false, your text must already be whitespace tokenized.");
        out2.println("# tokenize = true");
        out2.println();
        out2.println("# Write debugging information (words, top words, unknown words). Useful for");
        out2.println("# error analysis. Default is false.");
        out2.println("# debug = false");
        out2.println();
        out2.println("# Prefix for debugging output (if debug == true). Default is to use the");
        out2.println("# filename from 'file'");
        out2.println("# debugPrefix = ");
        out2.println();
        out2.println("######### parameters for training  #########");
        out2.println();
        out2.println("# model architecture: This is one or more comma separated strings, which");
        out2.println("# specify which extractors to use. Some of them take one or more integer");
        out2.println("# or string ");
        out2.println("# (file path) arguments in parentheses, written as m, n, and s below:");
        out2.println("# 'left3words', 'left5words', 'bidirectional', 'bidirectional5words',");
        out2.println("# 'generic', 'sighan2005', 'german', 'words(m,n)', 'wordshapes(m,n)',");
        out2.println("# 'biwords(m,n)', 'lowercasewords(m,n)', 'vbn(n)', distsimconjunction(s,m,n)',");
        out2.println("# 'naacl2003unknowns', 'naacl2003conjunctions', 'distsim(s,m,n)',");
        out2.println("# 'suffix(n)', 'prefix(n)', 'prefixsuffix(n)', 'capitalizationsuffix(n)',");
        out2.println("# 'wordshapes(m,n)', 'unicodeshapes(m,n)', 'unicodeshapeconjunction(m,n)',");
        out2.println("# 'lctagfeatures', 'order(k)', 'chinesedictionaryfeatures(s)'.");
        out2.println("# These keywords determines the features extracted.  'generic' is language independent.");
        out2.println("# distsim: Distributional similarity classes can be an added source of information");
        out2.println("# about your words. An English distsim file is included, or you can use your own.");
        out2.println("# arch = ");
        out2.println();
        out2.println("# 'wordFunction'.  A function applied to the text before training or tagging.");
        out2.println("# For example, edu.stanford.nlp.util.LowercaseFunction");
        out2.println("# This function turns all the words into lowercase");
        out2.println("# The function must implement edu.stanford.nlp.util.Function<String, String>");
        out2.println("# Blank means no preprocessing function");
        out2.println("# wordFunction = ");
        out2.println();
        out2.println("# 'language'.  This is really the tag set which is used for the");
        out2.println("# list of open-class tags, and perhaps deterministic  tag");
        out2.println("# expansion). Currently we have 'english', 'arabic', 'german', 'chinese'");
        out2.println("# or 'polish' predefined. For your own language, you can specify ");
        out2.println("# the same information via openClassTags or closedClassTags below");
        out2.println("# (only ONE of these three options may be specified). ");
        out2.println("# 'english' means UPenn English treebank tags. 'german' is STTS");
        out2.println("# 'chinese' is CTB, and Arabic is an expanded Bies mapping from the ATB");
        out2.println("# 'polish' means some tags that some guy on the internet once used. ");
        out2.println("# See the TTags class for more information.");
        out2.println("# lang = ");
        out2.println();
        out2.println("# a space-delimited list of open-class parts of speech");
        out2.println("# alternatively, you can specify language above to use a pre-defined list or specify the closed class tags (below)");
        out2.println("# openClassTags = ");
        out2.println();
        out2.println("# a space-delimited list of closed-class parts of speech");
        out2.println("# alternatively, you can specify language above to use a pre-defined list or specify the open class tags (above)");
        out2.println("# closedClassTags = ");
        out2.println();
        out2.println("# A boolean indicating whether you would like the trained model to set POS tags as closed");
        out2.println("# based on their frequency in training; default is false.  The frequency threshold can be set below. ");
        out2.println("# This option is ignored if any of {openClassTags, closedClassTags, lang} are specified.");
        out2.println("# learnClosedClassTags = ");
        out2.println();
        out2.println("# Used only if learnClosedClassTags=true.  Tags that have fewer tokens than this threshold are");
        out2.println("# considered closed in the trained model.");
        out2.println("# closedClassTagThreshold = ");
        out2.println();
        out2.println("# search method for optimization. Normally use the default 'qn'. choices: 'qn' (quasi-Newton),");
        out2.println("# 'cg' (conjugate gradient, 'owlqn' (L1 regularization) or 'iis' (improved iterative scaling)");
        out2.println("# search = qn");
        out2.println();
        out2.println("# for conjugate gradient or quasi-Newton search, sigma-squared smoothing/regularization");
        out2.println("# parameter. if left blank, the default is 0.5, which is usually okay");
        out2.println("# sigmaSquared = " + SIGMA_SQUARED);
        out2.println();
        out2.println("# for OWLQN search, regularization");
        out2.println("# parameter. if left blank, the default is 1.0, which is usually okay");
        out2.println("# regL1 = 1.0");
        out2.println();
        out2.println("# For improved iterative scaling, the number of iterations, otherwise ignored");
        out2.println("# iterations = 100");
        out2.println();
        out2.println("# rare word threshold. words that occur less than this number of");
        out2.println("# times are considered rare words.");
        out2.println("# rareWordThresh = 5");
        out2.println();
        out2.println("# minimum feature threshold. features whose history appears less");
        out2.println("# than this number of times are ignored.");
        out2.println("# minFeatureThresh = 5");
        out2.println();
        out2.println("# current word feature threshold. words that occur more than this");
        out2.println("# number of times will generate features with all of their occurring");
        out2.println("# tags.");
        out2.println("# curWordMinFeatureThresh = 2");
        out2.println();
        out2.println("# rare word minimum feature threshold. features of rare words whose histories");
        out2.println("# appear less than this times will be ignored.");
        out2.println("# rareWordMinFeatureThresh = 10");
        out2.println();
        out2.println("# very common word threshold. words that occur more than this number of");
        out2.println("# times will form an equivalence class by themselves. ignored unless");
        out2.println("# you are using equivalence classes.");
        out2.println("# veryCommonWordThresh = 250");
        out2.println();
        out2.println("# sgml = ");
        out2.println("# tagInside = ");
        out2.println();
        out2.println("# testFile and textFile can use multiple threads to process text.");
        out2.println("# nthreads = 1");
    }

    public Mode getMode() {
        if (!this.containsKey("mode")) {
            return null;
        }
        return Mode.valueOf(this.getProperty("mode"));
    }

    public void saveConfig(OutputStream os) throws IOException {
        ObjectOutputStream out2 = new ObjectOutputStream(os);
        out2.writeObject(this);
    }

    public static TaggerConfig readConfig(DataInputStream stream) throws IOException, ClassNotFoundException {
        ObjectInputStream in = new ObjectInputStream(stream);
        return (TaggerConfig)in.readObject();
    }

    static {
        defaultValues.put("arch", "");
        defaultValues.put("wordFunction", "");
        defaultValues.put("closedClassTags", "");
        defaultValues.put("closedClassTagThreshold", CLOSED_CLASS_THRESHOLD);
        defaultValues.put("search", SEARCH);
        defaultValues.put(TAG_SEPARATOR_PROPERTY, TAG_SEPARATOR);
        defaultValues.put("tokenize", "true");
        defaultValues.put("debug", "false");
        defaultValues.put("iterations", ITERATIONS);
        defaultValues.put("rareWordThresh", "5");
        defaultValues.put("minFeatureThresh", "5");
        defaultValues.put("curWordMinFeatureThresh", CUR_WORD_MIN_FEATURE_THRESH);
        defaultValues.put("rareWordMinFeatureThresh", RARE_WORD_MIN_FEATURE_THRESH);
        defaultValues.put("veryCommonWordThresh", VERY_COMMON_WORD_THRESH);
        defaultValues.put("occurringTagsOnly", "false");
        defaultValues.put("possibleTagsOnly", "false");
        defaultValues.put("sigmaSquared", SIGMA_SQUARED);
        defaultValues.put(ENCODING_PROPERTY, ENCODING);
        defaultValues.put("learnClosedClassTags", "false");
        defaultValues.put("verbose", "false");
        defaultValues.put("verboseResults", "true");
        defaultValues.put("sgml", "false");
        defaultValues.put("openClassTags", "");
        defaultValues.put("lang", "");
        defaultValues.put("tokenizerFactory", "");
        defaultValues.put("xmlInput", "");
        defaultValues.put("tagInside", "");
        defaultValues.put("sgml", "false");
        defaultValues.put("approximate", APPROXIMATE);
        defaultValues.put("tokenizerOptions", "");
        defaultValues.put("regL1", DEFAULT_REG_L1);
        defaultValues.put("outputFile", "");
        defaultValues.put("outputFormat", OUTPUT_FORMAT);
        defaultValues.put("outputFormatOptions", "");
        defaultValues.put("nthreads", NTHREADS);
    }

    public static enum Mode {
        TRAIN,
        TEST,
        TAG,
        DUMP;

    }
}

