/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.objectbank;

import edu.stanford.nlp.objectbank.IdentityFunction;
import edu.stanford.nlp.objectbank.IteratorFromReaderFactory;
import edu.stanford.nlp.util.AbstractIterator;
import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.XMLUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;

public class XMLBeginEndIterator<E>
extends AbstractIterator<E> {
    private final Pattern tagNamePattern;
    private final BufferedReader inputReader;
    private final Function<String, E> op;
    private final boolean keepInternalTags;
    private final boolean keepDelimitingTags;
    private final boolean countDepth;
    private E nextToken;

    public XMLBeginEndIterator(Reader in, String tagNameRegexp) {
        this(in, tagNameRegexp, new IdentityFunction(), false);
    }

    public XMLBeginEndIterator(Reader in, String tagNameRegexp, boolean keepInternalTags) {
        this(in, tagNameRegexp, new IdentityFunction(), keepInternalTags);
    }

    public XMLBeginEndIterator(Reader in, String tagNameRegexp, Function<String, E> op, boolean keepInternalTags) {
        this(in, tagNameRegexp, op, keepInternalTags, false);
    }

    public XMLBeginEndIterator(Reader in, String tagNameRegexp, boolean keepInternalTags, boolean keepDelimitingTags) {
        this(in, tagNameRegexp, new IdentityFunction(), keepInternalTags, keepDelimitingTags);
    }

    public XMLBeginEndIterator(Reader in, String tagNameRegexp, boolean keepInternalTags, boolean keepDelimitingTags, boolean countDepth) {
        this(in, tagNameRegexp, new IdentityFunction(), keepInternalTags, keepDelimitingTags, countDepth);
    }

    public XMLBeginEndIterator(Reader in, String tagNameRegexp, Function<String, E> op, boolean keepInternalTags, boolean keepDelimitingTags) {
        this(in, tagNameRegexp, op, keepInternalTags, keepDelimitingTags, false);
    }

    public XMLBeginEndIterator(Reader in, String tagNameRegexp, Function<String, E> op, boolean keepInternalTags, boolean keepDelimitingTags, boolean countDepth) {
        this.tagNamePattern = Pattern.compile(tagNameRegexp);
        this.op = op;
        this.keepInternalTags = keepInternalTags;
        this.keepDelimitingTags = keepDelimitingTags;
        this.countDepth = countDepth;
        this.inputReader = new BufferedReader(in);
        this.setNext();
    }

    private void setNext() {
        String s = this.getNext();
        this.nextToken = this.parseString(s);
    }

    private String getNext() {
        StringBuilder result = new StringBuilder();
        try {
            XMLUtils.XMLTag tag;
            do {
                XMLUtils.readUntilTag(this.inputReader);
                tag = XMLUtils.readAndParseTag(this.inputReader);
                if (tag != null) continue;
                return null;
            } while (!this.tagNamePattern.matcher(tag.name).matches() || tag.isEndTag || tag.isSingleTag);
            if (this.keepDelimitingTags) {
                result.append(tag.toString());
            }
            int depth = 1;
            while (true) {
                String tagString;
                String text;
                if ((text = XMLUtils.readUntilTag(this.inputReader)) != null) {
                    result.append(text);
                }
                if ((tag = XMLUtils.parseTag(tagString = XMLUtils.readTag(this.inputReader))) == null) {
                    return null;
                }
                if (this.tagNamePattern.matcher(tag.name).matches() && tag.isEndTag) {
                    if (this.countDepth && depth == 1 || !this.countDepth) {
                        if (this.keepDelimitingTags) {
                            result.append(tagString);
                        }
                        break;
                    }
                    --depth;
                    if (!this.keepInternalTags) continue;
                    result.append(tagString);
                    continue;
                }
                if (this.tagNamePattern.matcher(tag.name).matches() && !tag.isEndTag && !tag.isSingleTag && this.countDepth) {
                    ++depth;
                    if (!this.keepInternalTags) continue;
                    result.append(tagString);
                    continue;
                }
                if (!this.keepInternalTags) continue;
                result.append(tagString);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    protected E parseString(String s) {
        return this.op.apply(s);
    }

    @Override
    public boolean hasNext() {
        return this.nextToken != null;
    }

    @Override
    public E next() {
        if (this.nextToken == null) {
            throw new NoSuchElementException();
        }
        E token = this.nextToken;
        this.setNext();
        return token;
    }

    public static IteratorFromReaderFactory<String> getFactory(String tag) {
        return new XMLBeginEndIteratorFactory<String>(tag, new IdentityFunction(), false, false);
    }

    public static IteratorFromReaderFactory<String> getFactory(String tag, boolean keepInternalTags, boolean keepDelimitingTags) {
        return new XMLBeginEndIteratorFactory<String>(tag, new IdentityFunction(), keepInternalTags, keepDelimitingTags);
    }

    public static <E> IteratorFromReaderFactory<E> getFactory(String tag, Function<String, E> op) {
        return new XMLBeginEndIteratorFactory<E>(tag, op, false, false);
    }

    public static <E> IteratorFromReaderFactory<E> getFactory(String tag, Function<String, E> op, boolean keepInternalTags, boolean keepDelimitingTags) {
        return new XMLBeginEndIteratorFactory<E>(tag, op, keepInternalTags, keepDelimitingTags);
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 3) {
            System.err.println("usage: XMLBeginEndIterator file element keepInternalBoolean");
            return;
        }
        FileReader in = new FileReader(args[0]);
        XMLBeginEndIterator iter = new XMLBeginEndIterator(in, args[1], args[2].equalsIgnoreCase("true"));
        while (iter.hasNext()) {
            String s = (String)iter.next();
            System.out.println("*************************************************");
            System.out.println(s);
        }
        ((Reader)in).close();
    }

    static class XMLBeginEndIteratorFactory<E>
    implements IteratorFromReaderFactory<E> {
        private final String tag;
        private final Function<String, E> op;
        private final boolean keepInternalTags;
        private final boolean keepDelimitingTags;

        public XMLBeginEndIteratorFactory(String tag, Function<String, E> op, boolean keepInternalTags, boolean keepDelimitingTags) {
            this.tag = tag;
            this.op = op;
            this.keepInternalTags = keepInternalTags;
            this.keepDelimitingTags = keepDelimitingTags;
        }

        @Override
        public Iterator<E> getIterator(Reader r) {
            return new XMLBeginEndIterator<E>(r, this.tag, this.op, this.keepInternalTags, this.keepDelimitingTags);
        }
    }
}

