/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling;

import edu.stanford.nlp.ling.Document;
import edu.stanford.nlp.ling.DocumentReader;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.process.PTBTokenizer;
import edu.stanford.nlp.process.Tokenizer;
import edu.stanford.nlp.process.TokenizerFactory;
import edu.stanford.nlp.util.ErasureUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BasicDocument<L>
extends ArrayList<Word>
implements Document<L, Word, Word> {
    protected String title = "";
    protected String originalText;
    protected final List<L> labels = new ArrayList<L>();
    protected TokenizerFactory<Word> tokenizerFactory;
    private static final long serialVersionUID = -24171720584352262L;

    public BasicDocument() {
        this(PTBTokenizer.factory());
    }

    public BasicDocument(TokenizerFactory<Word> tokenizerFactory) {
        this.setTokenizerFactory(tokenizerFactory);
    }

    public BasicDocument(Document<L, Word, Word> d) {
        this((Collection<Word>)d);
    }

    public BasicDocument(Collection<Word> d) {
        this();
        this.addAll(d);
    }

    public static <L> BasicDocument<L> init(String text, String title, boolean keepOriginalText) {
        BasicDocument<L> basicDocument = new BasicDocument<L>();
        basicDocument.setTitle(title);
        basicDocument.originalText = keepOriginalText ? text : null;
        basicDocument.parse(text == null ? "" : text);
        return basicDocument;
    }

    public static <L> BasicDocument<L> init(String text, String title) {
        return BasicDocument.init(text, title, true);
    }

    public static <L> BasicDocument<L> init(String text, boolean keepOriginalText) {
        return BasicDocument.init(text, null, keepOriginalText);
    }

    public static <L> BasicDocument<L> init(String text) {
        return BasicDocument.init(text, null, true);
    }

    public static <L> BasicDocument<L> init() {
        return BasicDocument.init((String)null, null, true);
    }

    public static <L> BasicDocument<L> init(Reader textReader, String title, boolean keepOriginalText) throws IOException {
        return BasicDocument.init(DocumentReader.readText(textReader), title, keepOriginalText);
    }

    public BasicDocument<L> init(Reader textReader, String title) throws IOException {
        return BasicDocument.init(textReader, title, true);
    }

    public BasicDocument<L> init(Reader textReader, boolean keepOriginalText) throws IOException {
        return BasicDocument.init(textReader, null, keepOriginalText);
    }

    public BasicDocument<L> init(Reader textReader) throws IOException {
        return BasicDocument.init(textReader, null, true);
    }

    public BasicDocument<L> init(File textFile, String title, boolean keepOriginalText) throws FileNotFoundException, IOException {
        Reader in = DocumentReader.getReader(textFile);
        BasicDocument<L> bd = BasicDocument.init(in, title, keepOriginalText);
        in.close();
        return bd;
    }

    public BasicDocument<L> init(File textFile, String title) throws FileNotFoundException, IOException {
        return this.init(textFile, title, true);
    }

    public BasicDocument<L> init(File textFile, boolean keepOriginalText) throws FileNotFoundException, IOException {
        return this.init(textFile, textFile.getCanonicalPath(), keepOriginalText);
    }

    public BasicDocument<L> init(File textFile) throws FileNotFoundException, IOException {
        return this.init(textFile, textFile.getCanonicalPath(), true);
    }

    public BasicDocument<L> init(URL textURL, String title, boolean keepOriginalText) throws IOException {
        return BasicDocument.init(DocumentReader.getReader(textURL), title, keepOriginalText);
    }

    public BasicDocument<L> init(URL textURL, String title) throws FileNotFoundException, IOException {
        return this.init(textURL, title, true);
    }

    public BasicDocument<L> init(URL textURL, boolean keepOriginalText) throws FileNotFoundException, IOException {
        return this.init(textURL, textURL.toExternalForm(), keepOriginalText);
    }

    public BasicDocument<L> init(URL textURL) throws FileNotFoundException, IOException {
        return this.init(textURL, textURL.toExternalForm(), true);
    }

    public BasicDocument<L> init(List<? extends Word> words, String title) {
        this.setTitle(title);
        this.originalText = null;
        this.addAll(words);
        return this;
    }

    public BasicDocument<L> init(List<? extends Word> words) {
        return this.init(words, null);
    }

    protected void parse(String text) {
        Tokenizer<Word> toke = this.tokenizerFactory.getTokenizer(new StringReader(text));
        this.addAll(toke.tokenize());
    }

    @Override
    public Collection<Word> asFeatures() {
        return this;
    }

    @Override
    public L label() {
        return this.labels.size() > 0 ? (L)this.labels.get(0) : null;
    }

    @Override
    public Collection<L> labels() {
        return this.labels;
    }

    public void setLabel(L label) {
        this.labels.clear();
        this.addLabel(label);
    }

    public void setLabels(Collection<L> labels) {
        this.labels.clear();
        if (labels != null) {
            this.labels.addAll(labels);
        }
    }

    public void addLabel(L label) {
        if (label != null) {
            this.labels.add(label);
        }
    }

    @Override
    public String title() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title == null ? "" : title;
    }

    public TokenizerFactory<Word> tokenizerFactory() {
        return this.tokenizerFactory;
    }

    public void setTokenizerFactory(TokenizerFactory<Word> tokenizerFactory) {
        this.tokenizerFactory = tokenizerFactory;
    }

    @Override
    public <OUT> Document<L, Word, OUT> blankDocument() {
        BasicDocument<L> bd;
        try {
            bd = (BasicDocument<L>)ErasureUtils.uncheckedCast(this.getClass().newInstance());
        }
        catch (Exception e) {
            bd = new BasicDocument<L>();
        }
        bd.setTitle(this.title());
        bd.setLabels(this.labels());
        bd.setTokenizerFactory(this.tokenizerFactory);
        return (Document)ErasureUtils.uncheckedCast(bd);
    }

    public String originalText() {
        return this.originalText;
    }

    public String presentableText() {
        StringBuilder sb = new StringBuilder();
        for (Word cur : this) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(cur.word());
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            BasicDocument.printState(BasicDocument.init("this is the text", "this is the title [String]", true));
            BasicDocument.printState(BasicDocument.init(new StringReader("this is the text"), "this is the title [Reader]", true));
            File f = File.createTempFile("BasicDocumentTestFile", null);
            f.deleteOnExit();
            PrintWriter out2 = new PrintWriter(new FileWriter(f));
            out2.print("this is the text");
            out2.flush();
            out2.close();
            BasicDocument.printState(new BasicDocument().init(f, "this is the title [File]", true));
            BasicDocument.printState(new BasicDocument().init(new URL("http://www.stanford.edu/~jsmarr/BasicDocumentTestFile.txt"), "this is the title [URL]", true));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <L> void printState(BasicDocument<L> bd) throws Exception {
        System.err.println("BasicDocument:");
        System.err.println("\tTitle: " + bd.title());
        System.err.println("\tLabels: " + bd.labels());
        System.err.println("\tOriginalText: " + bd.originalText());
        System.err.println("\tWords: " + bd);
        System.err.println();
    }
}

