# -*- coding: utf-8 -*-
import time;

def Dynamic_Programming( num_point, s ):
    # Prepare
    d_Int = [ [ 0 for x in range(num_point+1) ] 
             for y in range(num_point+1) ];
    d_N = [ [ [ 0 for x in range(num_point+1) ] 
             for y in range(num_point+1) ] 
                for z in range(num_point+1) ];
    d_L = [ [ [ 0 for x in range(num_point+1) ] 
            for y in range(num_point+1) ] 
                for z in range(num_point+1) ];
    d_R = [ [ [ 0 for x in range(num_point+1) ] 
             for y in range(num_point+1) ] 
                for z in range(num_point+1) ];
    d_LR = [ [ [ 0 for x in range(num_point+1) ] 
              for y in range(num_point+1) ] 
                for z in range(num_point+1) ];
    d_C = [ [ [ [ 0 for x in range(num_point+1) ] 
              for y in range(num_point+1) ] 
                for z in range(num_point+1) ]
                    for k in range(num_point+1) ];
    # Init
    for i in range(1,num_point):
        d_Int[i][i+1] = s[i][i+1];
        for x in range(1,num_point+1):
            d_L[i][i+1][x] = d_R[i][i+1][x] = d_N[i][i+1][x] = d_LR[i][i+1][x] = s[i][i+1];

    # dp
    for dist in range(2,num_point):
        for i in range(1,num_point-dist+1):
            j = i+dist;
            # Int
            d_Int[i][j] = 0;
            for k in range(i+1, j):
                # Case 1
                d_Int[i][j] = max( d_Int[i][j],
                                  d_LR[i][k][j] + d_Int[k][j] + s[i][j] );                
                # Case 3.2
                for l in range(i+1,k):
                    d_Int[i][j] = max( d_Int[i][j],
                                      d_R[i][l][k] + d_Int[l][k] + d_L[k][j][l] 
                                      + s[i][k] + s[l][j] + s[i][j] );
            # N, L, R, LR, C
            for x in range(1,i):
                Dp_NLRC( i, j, x, num_point, s, [d_Int, d_N, d_L, d_R, d_LR, d_C] );
            for x in range(j+1,num_point+1):
                Dp_NLRC( i, j, x, num_point, s, [d_Int, d_N, d_L, d_R, d_LR, d_C] );
                
    return d_Int[1][num_point];
            
def Dp_NLRC( i, j, x, num_point, s, dp ):
    [d_Int, d_N, d_L, d_R, d_LR, d_C] = dp;
    # N
    d_N[i][j][x] = d_Int[i][j];
    for k in range(i+1,j):
        d_N[i][j][x] = max( d_N[i][j][x], 
                           d_N[i][k][x] + d_Int[k][j] + s[x][k] );
    
    # L
    d_L[i][j][x] = d_Int[i][j];
    for k in range(i+1, j):
        d_L[i][j][x] = max( d_L[i][j][x],
                           d_L[i][k][x] + d_N[k][j][i] + s[x][k] + s[i][j] );
        d_L[i][j][x] = max( d_L[i][j][x],
                           d_Int[i][k] +  d_L[k][j][i] + s[x][k] + s[i][j] );
    
    # R
    d_R[i][j][x] = d_Int[i][j];
    for k in range(i+1, j):
        d_R[i][j][x] = max( d_R[i][j][x],
                           d_N[i][k][j] + d_R[k][j][x] + s[x][k] + s[i][j] );
        d_R[i][j][x] = max( d_R[i][j][x],
                           d_R[i][k][j] + d_Int[k][j]  + s[x][k] + s[i][j] );
    
    # C
    for a in range(i+1, j):
        b = j;
        d_C[x][i][a][b] = 0;
        for k in range(i+2,a):
            d_C[x][i][a][b] = max( d_C[x][i][a][b],
                                  d_C[x][i][a][k] + d_Int[a][b] + s[k][b] );
    for b in range(i+2,j):
        a = j;
        d_C[x][i][a][b] = 0;
        for k in range(i+1,b):
            d_C[x][i][a][b] = max( d_C[x][i][a][b],
                                  d_C[x][i][k][b] + d_Int[b][a] + s[k][a] );
            d_C[x][i][a][b] = max( d_C[x][i][a][b],
                                  d_Int[i][k] + d_Int[k][b] + d_Int[b][a]
                                  + s[x][k] + s[i][b] + s[k][a] );
    
    # LR
    d_LR[i][j][x] = max( d_L[i][j][x], d_R[i][j][x] );
    for k in range(i+1,j):
        d_LR[i][j][x] = max( d_LR[i][j][x],
                            d_L[i][k][x] + d_R[k][j][x] + s[x][k] + s[i][j] );
        d_LR[i][j][x] = max( d_LR[i][j][x],
                            d_C[x][i][k][j] + s[k][x] + s[i][j] );
    return;


def Read_Map(fin):
    edge_in = [0];
    read_edge = [[]];
    point = 0;
    end_file = False;
    while 1:
        line = fin.readline();
        if len(line)<5:
            if line=="":
                end_file = True;
            break;
        point += 1;
        read_edge.append( [0] );
        line = line.strip().split(" ");
        if line[10]!="_":
            edge_in.append( point );
        for i in range(len(line)-11):
            if line[i+11]!="_":
                read_edge[ point ].append( True );
            else:
                read_edge[ point ].append( False );
    num_edge = 0;
    num_point = point;
    s = [ [ 0 for x in range(num_point+1)] for y in range(num_point+1) ];
    for x in range(1, num_point+1):
        for y in range(len(edge_in)):
            if read_edge[x][y]:
                num_edge += 1;
                s[x][ edge_in[y] ] = s[ edge_in[y] ][x] = 1;
    return [num_point, num_edge, s, end_file];
    
def Run():
    time_begin = time.clock();
    time_pre = time_begin;
    fin = open("input.txt","r");
    sum = 0;
    edge_num1 = 0;
    edge_num2 = 0;
    count = [ 0 for i in range(101) ];
    while 1:
        [num_point, num1, s, end_file] = Read_Map(fin);
        if end_file:
            break;
        if num1==0 and num_point==0:
            continue;
        num2 = Dynamic_Programming( num_point, s);
        sum += 1;
        edge_num1 += num1;
        edge_num2 += num2;
        if num2 > num1 or num1-num2 > 100:
            print "Error %d %d" % (num1, num2);
        else:
            count[num1-num2] += 1;
        if sum%10==0:
            time_now = time.clock();
            print "now: %d\t cost: %.2fs" % (sum, time_now-time_pre);
            time_pre = time_now;
        
    print "total time: %.2fs" % (time.clock()-time_begin);
    print "sum : %d" % sum;
    print "edge cover: %d / %d" % (edge_num2, edge_num1);
    for i in range(101):
        if count[i]:
            print "count %d:\t%d\t%.2lf%%" % (i, count[i], float(count[i])/sum*100);
    fin.close();
    
Run();


    