/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.IOUtils;
import fig.basic.IntRef;
import fig.basic.ListUtils;
import fig.basic.OrderedMap;
import fig.basic.Pair;
import fig.basic.StrUtils;
import fig.basic.Utils;
import fig.html.HtmlCell;
import fig.html.HtmlDiv;
import fig.html.HtmlRow;
import fig.html.HtmlTable;
import fig.servlet.ArgumentException;
import fig.servlet.DividerItem;
import fig.servlet.Field;
import fig.servlet.FieldListMap;
import fig.servlet.FieldSpecItem;
import fig.servlet.FileUtils;
import fig.servlet.IntrinsicField;
import fig.servlet.InvalidHandleItem;
import fig.servlet.ItemsOpResponseParams;
import fig.servlet.MyException;
import fig.servlet.NameNotFoundException;
import fig.servlet.OperationRP;
import fig.servlet.Permissions;
import fig.servlet.RequestParams;
import fig.servlet.ResponseElement;
import fig.servlet.ResponseObject;
import fig.servlet.ResponseParams;
import fig.servlet.Trail;
import fig.servlet.UpdateQueue;
import fig.servlet.UpdateSpec;
import fig.servlet.Value;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class Item {
    public static final Field trailField = new IntrinsicField("trail", "Unique list of names that identifies the item");
    public static final Field countField = new IntrinsicField("count", "#", "Number of child items");
    public static final Field descriptionField = new IntrinsicField("description", "Description of this item.");
    public static final Field mutableDescriptionField = new IntrinsicField("description", "Description of this item.").setMutable(true);
    public static final FieldListMap countDescriptionFields = new FieldListMap(ListUtils.newList(countField, descriptionField));
    public static final FieldListMap countMutableDescriptionFields = new FieldListMap(ListUtils.newList(countField, mutableDescriptionField));
    protected final Item parent;
    protected final String name;
    public final String sourcePath;
    protected Map<String, String> metadataMap;
    protected OrderedMap<String, Item> items;
    protected boolean parentHasSentMe;
    protected boolean isDead;

    public Item(Item parent, String name, String sourcePath) {
        this.parent = parent;
        this.name = name;
        this.sourcePath = sourcePath;
        this.metadataMap = new LinkedHashMap<String, String>();
        this.items = new OrderedMap();
    }

    protected boolean isRoot() {
        return this.parent == null;
    }

    protected String childNameToIndexSourcePath(String name) {
        return new File(this.sourcePath, String.valueOf(name) + ".index").toString();
    }

    protected Trail getTrail() {
        ArrayList<String> names = new ArrayList<String>();
        Item item = this;
        while (!item.isRoot()) {
            names.add(item.name);
            item = item.parent;
        }
        Collections.reverse(names);
        return new Trail(names);
    }

    protected Item getRoot() {
        Item item = this;
        while (!item.isRoot()) {
            item = item.parent;
        }
        return item;
    }

    protected Item getItem(String name) throws MyException {
        Item item = this.items.get(name);
        if (item == null) {
            throw new NameNotFoundException(this, name);
        }
        return item;
    }

    protected Item getItemEasy(String name) {
        return this.items.get(name);
    }

    protected Item getItemOrNew(String name) throws MyException {
        Item item = this.getItemEasy(name);
        if (item == null) {
            item = this.newItem(name);
        }
        return item;
    }

    public Item getItemOrNewAdd(String name) throws MyException {
        Item item = this.getItemEasy(name);
        if (item == null) {
            item = this.newItem(name);
            this.addItem(item);
        }
        return item;
    }

    public Item trailToItem(Trail trail) throws MyException {
        Item item = this.getRoot();
        String[] stringArray = trail.names;
        int n = trail.names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            item = item.getItem(name);
            ++n2;
        }
        return item;
    }

    protected void addItem(Item item) {
        this.addItem(this.items, item);
    }

    protected synchronized void addItem(OrderedMap<String, Item> items, Item item) {
        if (item.isDead) {
            return;
        }
        items.put(this.itemToNewName(items, item), item);
    }

    protected boolean isHidden() {
        return false;
    }

    protected String getDescription() {
        return this.metadataMap.get("description");
    }

    protected Value getIntrinsicFieldValue(String fieldName) throws MyException {
        if (fieldName.equals("trail")) {
            return new Value(this.getTrail().toDisplayString());
        }
        if (fieldName.equals("count")) {
            return new Value(this.items.size());
        }
        if (fieldName.equals("description")) {
            return new Value(this.getDescription());
        }
        return new Value(this.metadataMap.get(fieldName));
    }

    protected void changeIntrinsicFieldValue(String fieldName, String value) throws MyException {
        this.metadataMap.put(fieldName, value);
        Item item = this;
        while (item != null && item.isEmbedded()) {
            item = item.parent;
        }
        item.saveToDisk();
    }

    protected FieldListMap getMetadataFields() {
        FieldListMap fields = new FieldListMap();
        fields.add(trailField);
        for (Map.Entry<String, String> e : this.metadataMap.entrySet()) {
            fields.add(e.getKey(), e.getKey(), e.getValue());
        }
        if (!fields.containsKey("description")) {
            fields.add(descriptionField);
        }
        return fields;
    }

    protected FieldListMap getItemsFields() {
        return countDescriptionFields;
    }

    protected FieldListMap getDynamicFieldListMap() {
        FieldSpecItem fieldSpecItem = null;
        for (Item item : this.items.values()) {
            if (!(item instanceof FieldSpecItem)) continue;
            fieldSpecItem = (FieldSpecItem)item;
            break;
        }
        return fieldSpecItem != null ? fieldSpecItem.createFieldListMap() : null;
    }

    protected HtmlTable getMetadataTable() throws MyException {
        FieldListMap fields = this.getMetadataFields();
        HtmlTable table = new HtmlTable();
        table.setNoWrap(true);
        table.setAttr("trail", this.getTrail().toRepnString());
        if (this.isView()) {
            table.setAttr("isView");
        }
        HtmlRow header = new HtmlRow();
        header.setIsHeader(true);
        header.addCell("");
        header.addCell("");
        table.addRow(header);
        for (Field field : fields.values()) {
            HtmlRow row = new HtmlRow();
            row.setAttr("itemName", field.name);
            row.setAttr("gloss", field.gloss);
            row.addCell(field.displayName);
            row.addCell(this.fieldToCell(field, field.getValue((Item)this).value));
            table.addRow(row);
        }
        return table;
    }

    protected HtmlCell fieldToCell(Field field, Object value) {
        HtmlCell cell = new HtmlCell(value);
        if (field.numeric) {
            cell.setAttr("numeric");
            cell.setAttr("justify", "right");
        }
        if (field.mutable) {
            cell.setAttr("mutable");
        }
        if (field.multiline) {
            cell.setAttr("multiline");
        }
        return cell;
    }

    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        this.loadFromDisk();
    }

    protected void updateMeNow(UpdateSpec spec) throws MyException {
        this.update(spec, UpdateQueue.Priority.HIGH);
    }

    protected HtmlTable getItemsTable() throws MyException {
        FieldListMap fields = this.getItemsFields();
        HtmlTable table = new HtmlTable();
        table.setNoWrap(true);
        if (this.isView()) {
            table.setAttr("isView");
        }
        HtmlRow header = new HtmlRow();
        header.setIsHeader(true);
        HtmlCell cell = new HtmlCell("name");
        cell.setAttr("fieldName", "name");
        cell.setAttr("gloss", "Name");
        header.addCell(cell);
        for (Field field : fields.values()) {
            if (field.hidden) continue;
            cell = this.fieldToCell(field, field.displayName);
            cell.setAttr("fieldName", field.name);
            cell.setAttr("gloss", field.gloss);
            header.addCell(cell);
        }
        table.addRow(header);
        Pair<String, Boolean> sortSpec = this.getDefaultSortSpec();
        Field sortField = null;
        boolean sortByName = false;
        boolean reverse = false;
        if (sortSpec != null) {
            sortByName = "name".equals(sortSpec.getFirst());
            sortField = (Field)fields.get(sortSpec.getFirst());
            reverse = sortSpec.getSecond();
        }
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (String name : this.items.keys()) {
            Item item = this.items.get(name);
            if (item.isHidden() || item.isDead) continue;
            Object cmpKey = null;
            if (sortByName) {
                cmpKey = name;
            } else if (sortField != null) {
                String s;
                Value value = sortField.getValue(item);
                String string = s = value.cmpKey == null ? value.value : value.cmpKey;
                cmpKey = sortField.numeric ? Double.valueOf(Utils.parseDoubleEasy(s)) : (s == null ? "" : s);
            }
            item.parentHasSentMe = true;
            entries.add(new Entry(name, item, (Comparable)cmpKey));
        }
        if (sortByName || sortField != null) {
            Collections.sort(entries);
            if (reverse) {
                Collections.reverse(entries);
            }
        }
        Field lastMutableField = null;
        for (Field field : fields.values()) {
            if (!field.mutable) continue;
            lastMutableField = field;
        }
        for (Entry entry : entries) {
            String name = entry.name;
            Item item = entry.item;
            HtmlRow row = new HtmlRow();
            row.setAttr("itemName", name);
            if (item.isView()) {
                row.setAttr("isView");
            }
            if (item instanceof DividerItem) {
                name = "<hr color=\"darkblue\">";
            }
            row.addCell(name);
            for (Field field : fields.values()) {
                if (field.hidden) continue;
                if (item instanceof DividerItem) {
                    cell = new HtmlCell(field == lastMutableField ? ((DividerItem)item).description : "<hr color=\"darkblue\">");
                } else {
                    Value value = field.getValue(item);
                    cell = new HtmlCell(value.value);
                    if (field.width != 0) {
                        cell.setAttr("width", field.width);
                    }
                    if (value.cmpKey != null) {
                        cell.setAttr("cmpKey", value.cmpKey);
                    }
                }
                row.addCell(cell);
            }
            table.addRow(row);
        }
        return table;
    }

    protected Pair<String, Boolean> getDefaultSortSpec() {
        return null;
    }

    protected HtmlDiv putInBlock(HtmlTable table, String htmlName, String op) {
        if (htmlName == null) {
            htmlName = "unknown";
        }
        Trail trail = this.getTrail();
        table.setId(String.valueOf(htmlName) + ".table");
        String title = String.valueOf(this.getClass().getName()) + " (" + trail.toDisplayString() + ")";
        String description = this.getDescription();
        if (!StrUtils.isEmpty(description)) {
            title = String.valueOf(title) + ": " + description;
        }
        HtmlDiv block = new HtmlDiv(new HtmlDiv(title), new HtmlDiv(table));
        block.setId(String.valueOf(htmlName) + ".block");
        block.setAttr("type", this.tableType());
        block.setAttr("op", op);
        block.setAttr("trail", trail.toRepnString());
        return block;
    }

    protected synchronized ResponseParams saveItems(RequestParams req) throws MyException {
        String[] names;
        ResponseParams resp = new ResponseParams("Saved items");
        OrderedMap<String, Item> newItems = new OrderedMap<String, Item>();
        String[] stringArray = names = req.getStringListReq("items");
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Item item = this.getItem(name);
            this.addItem(newItems, item);
            ++n2;
        }
        if (!req.getBoolean("force")) {
            for (String name : this.items.keys()) {
                Item item = this.items.get(name);
                if (item.parentHasSentMe || newItems.containsKey(name)) continue;
                this.addItem(newItems, item);
                resp.put(name, "NEW");
            }
        }
        this.items = newItems;
        this.saveToDisk();
        return resp;
    }

    protected boolean namesAreIndices() {
        return false;
    }

    protected String itemToNewName(OrderedMap<String, Item> items, Item item) {
        if (this.namesAreIndices()) {
            return "" + items.size();
        }
        String baseName = item.name;
        int q = 0;
        String name;
        while (items.containsKey(name = String.valueOf(baseName) + (q == 0 ? "" : "_" + q))) {
            ++q;
        }
        return name;
    }

    protected String itemToNewName(Item item) {
        return this.itemToNewName(this.items, item);
    }

    protected abstract boolean isView();

    protected abstract Item newItem(String var1) throws MyException;

    protected String tableType() {
        return "Item";
    }

    protected String itemToHandle(Item item) throws MyException {
        if (item instanceof InvalidHandleItem) {
            return ((InvalidHandleItem)item).handle;
        }
        if (item instanceof DividerItem) {
            return ".div\t" + ((DividerItem)item).description;
        }
        if (item.parent != this) {
            return ".trail\t" + item.getTrail().toRepnString();
        }
        return ".name\t" + item.name;
    }

    protected Item handleToItem(String handle) throws MyException {
        String[] tokens = handle.split("\t", 2);
        if (tokens.length == 1) {
            tokens = new String[]{".name", tokens[0]};
        }
        Item item = null;
        if (tokens[0].equals(".div")) {
            item = new DividerItem(this, "divider", tokens[1]);
        } else if (tokens[0].equals(".trail")) {
            item = this.trailToItem(new Trail(tokens[1]));
        } else if (tokens[0].equals(".name")) {
            item = this.getItemOrNew(tokens[1]);
        } else {
            throw new MyException("Invalid handle");
        }
        return item;
    }

    protected String fileSourcePath() {
        if (this.sourcePath == null) {
            return null;
        }
        return new File(this.sourcePath).isDirectory() ? new File(this.sourcePath, "_index.index").toString() : this.sourcePath;
    }

    protected synchronized void loadFromDisk() throws MyException {
        if (this.fileSourcePath() == null) {
            return;
        }
        this.indentInput(0, IOUtils.readLinesEasy(this.fileSourcePath()), new IntRef(0));
    }

    private void indentInput(int indent, List<String> lines, IntRef lineIdx) throws MyException {
        OrderedMap<String, Item> newItems = new OrderedMap<String, Item>();
        Item item = null;
        this.metadataMap.clear();
        while (lineIdx.value < lines.size()) {
            String line = lines.get(lineIdx.value);
            int observedIndent = 0;
            while (observedIndent < line.length() && line.charAt(observedIndent) == '\t') {
                ++observedIndent;
            }
            if (observedIndent < indent) break;
            if (observedIndent > indent) {
                super.indentInput(observedIndent, lines, lineIdx);
                continue;
            }
            String[] tokens = line.substring(observedIndent).split("\t", 2);
            if (tokens.length == 1) {
                tokens = new String[]{"item", tokens[0]};
            }
            if (tokens[0].equals("item")) {
                try {
                    item = this.handleToItem(tokens[1]);
                    this.addItem(newItems, item);
                }
                catch (MyException e) {
                    item = new InvalidHandleItem(this, tokens[1]);
                    this.addItem(newItems, item);
                }
            } else {
                this.metadataMap.put(tokens[0], tokens[1]);
            }
            ++lineIdx.value;
        }
        this.items = newItems;
    }

    protected synchronized void saveToDisk() throws MyException {
        if (StrUtils.isEmpty(this.fileSourcePath())) {
            return;
        }
        try {
            PrintWriter out = IOUtils.openOut(this.fileSourcePath());
            this.indentOutput(0, out);
            out.close();
        }
        catch (IOException e) {
            throw new MyException("Unable to save to " + this.fileSourcePath());
        }
    }

    private void indentOutput(int indent, PrintWriter out) throws MyException {
        StringBuilder indBuf = new StringBuilder();
        int i = 0;
        while (i < indent) {
            indBuf.append('\t');
            ++i;
        }
        for (Map.Entry<String, String> e : this.metadataMap.entrySet()) {
            out.println(indBuf + e.getKey() + "\t" + (e.getValue() == null ? "" : e.getValue()));
        }
        for (Item item : this.items.values()) {
            String handle = this.itemToHandle(item);
            if (handle == null) continue;
            out.println(indBuf + "item\t" + handle);
            if (!item.isEmbedded() || item.parent != this) continue;
            item.indentOutput(indent + 1, out);
        }
    }

    private boolean isEmbedded() {
        return StrUtils.isEmpty(this.sourcePath) || StrUtils.isEmpty(this.fileSourcePath());
    }

    public ResponseObject handleOperation(OperationRP req, Permissions perm) throws MyException {
        String op = req.op;
        if (op.equals("getMetadataTable")) {
            this.updateMeNow(req.updateSpec);
            HtmlTable table = this.getMetadataTable();
            return new ResponseElement(this.putInBlock(table, (String)req.get("name"), op));
        }
        if (op.equals("saveMetadata")) {
            perm.checkCanModify();
            Field field = (Field)this.getMetadataFields().get(req.getReq("item"));
            String value = req.getReq("value");
            field.changeValue(this, value);
            return new ResponseParams("Saved " + this.name + "." + field.name + " := " + value);
        }
        if (op.equals("copyItem")) {
            perm.checkCanModify();
            Trail destTrail = new Trail(req.getReq("destTrail"));
            Item destItem = this.trailToItem(destTrail);
            destItem.addItem(this);
            destItem.saveToDisk();
            return new ResponseParams("Added " + this.name + " to " + destItem.name + ", which now has " + destItem.items.size() + " items");
        }
        if (op.equals("childOp")) {
            String childOp = req.getReq("childOp");
            if ((req = new OperationRP(childOp, req)).containsKey("childItem")) {
                Item item = this.getItem(req.getReq("childItem"));
                return item.handleOperation(req, perm);
            }
            if (req.containsKey("childItems")) {
                String[] childItemNames = req.getStringListReq("childItems");
                ItemsOpResponseParams resp = new ItemsOpResponseParams(childOp);
                String[] stringArray = childItemNames;
                int n = childItemNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String childItemName = stringArray[n2];
                    try {
                        Item item = this.getItem(childItemName);
                        ResponseObject childResp = item.handleOperation(req, perm);
                        if (childResp instanceof ResponseParams) {
                            resp.setSuccess(childItemName, ((ResponseParams)childResp).getMsg());
                        } else {
                            resp.setSuccess(childItemName, childResp.toString());
                        }
                    }
                    catch (MyException e) {
                        resp.setFailed(childItemName, e.getMessage());
                    }
                    ++n2;
                }
                return resp.finish();
            }
            throw new ArgumentException("Either childItem or childItems required");
        }
        if (op.equals("getItemsTable")) {
            this.updateMeNow(req.updateSpec);
            HtmlTable table = this.getItemsTable();
            return new ResponseElement(this.putInBlock(table, (String)req.get("name"), op));
        }
        if (op.equals("saveItems")) {
            perm.checkCanModify();
            return this.saveItems(req);
        }
        if (op.equals("saveValues")) {
            perm.checkCanModify();
            Item item = this.getItem(req.getReq("item"));
            Field field = (Field)this.getItemsFields().get(req.getReq("field"));
            String value = req.getReq("value");
            field.changeValue(item, value);
            return new ResponseParams("Saved " + item.name + "." + field.name + " := " + value);
        }
        if (op.equals("addItem")) {
            Trail srcTrail = new Trail(req.getReq("srcTrail"));
            Item srcItem = this.trailToItem(srcTrail);
            this.addItem(srcItem);
            this.saveToDisk();
            return new ResponseParams("Added " + srcTrail.toDisplayString() + " to " + this);
        }
        if (op.equals("addItems")) {
            Trail srcTrail = new Trail(req.getReq("srcTrail"));
            Item srcItem = this.trailToItem(srcTrail);
            for (Item item : srcItem.items.values()) {
                this.addItem(item);
            }
            this.saveToDisk();
            return new ResponseParams("Added " + srcTrail.toDisplayString() + " to " + this);
        }
        if (op.equals("newItem")) {
            Item item;
            String name = req.getReq("name");
            if (name.startsWith("-")) {
                item = new DividerItem(this, "divider", name.substring(1));
            } else {
                if (name.equals("")) {
                    int i = 0;
                    while (this.items.containsKey(name = "" + i)) {
                        ++i;
                    }
                }
                item = this.newItem(name);
            }
            this.addItem(item);
            this.saveToDisk();
            return new ResponseParams("Created new " + item + " in " + this);
        }
        if (op.equals("purge")) {
            if (this.sourcePath == null || !IOUtils.purgePath(new File(this.sourcePath))) {
                throw new MyException("Unable to purge " + this.name);
            }
            this.isDead = true;
            return new ResponseParams("Purged " + this.name);
        }
        if (op.equals("getIntrinsicField")) {
            return new ResponseParams(this.getIntrinsicFieldValue((String)req.getReq((String)"field")).value);
        }
        throw new MyException("Unknown operation: " + op);
    }

    protected void updateItemsFromDir(int depth, FileUtils.TraverseSpec spec, boolean stripExt) throws MyException {
        OrderedMap<String, Item> newItems = new OrderedMap<String, Item>();
        List<String> childFileNames = FileUtils.getChildren(this.sourcePath, depth, spec);
        childFileNames = this.sortFileNames(childFileNames);
        for (String childFileName : childFileNames) {
            String childName = stripExt ? IOUtils.stripFileExt(childFileName) : childFileName;
            Item item = this.getItemEasy(childName);
            if (item == null || item.isDead) {
                item = this.newItem(childName);
            }
            this.addItem(newItems, item);
        }
        this.items = newItems;
    }

    private List<String> sortFileNames(List<String> names) {
        ArrayList<Pair<String, String>> pairs = new ArrayList<Pair<String, String>>();
        for (String name : names) {
            StringBuilder buf = new StringBuilder();
            int n = 0;
            while (n < name.length() && Character.isDigit(name.charAt(n))) {
                ++n;
            }
            while (n < 5) {
                buf.append('0');
                ++n;
            }
            pairs.add(new Pair<String, String>(name, String.valueOf(buf.toString()) + name));
        }
        Collections.sort(pairs, new Pair.SecondComparator());
        ArrayList<String> newNames = new ArrayList<String>();
        for (Pair pair : pairs) {
            newNames.add((String)pair.getFirst());
        }
        return newNames;
    }

    protected void updateItemsFromFile(UpdateSpec updateSpec) throws MyException {
        this.updateItemsFromFile(updateSpec, Collections.EMPTY_LIST, Collections.EMPTY_LIST);
    }

    protected void updateItemsFromFile(UpdateSpec updateSpec, List<? extends Item> prependItems, List<? extends Item> appendItems) throws MyException {
        this.loadFromDisk();
        OrderedMap<String, Item> newItems = new OrderedMap<String, Item>();
        for (Item item : prependItems) {
            this.addItem(newItems, item);
        }
        for (Item item : this.items.values()) {
            this.addItem(newItems, item);
        }
        for (Item item : appendItems) {
            this.addItem(newItems, item);
        }
        this.items = newItems;
    }

    protected void updateChildren(UpdateSpec spec, UpdateQueue.Priority priority) {
        if (priority == UpdateQueue.Priority.LOW) {
            return;
        }
        spec.queue.merge(this.getUpdateQueue(priority));
    }

    protected UpdateQueue getUpdateQueue(UpdateQueue.Priority priority) {
        UpdateQueue queue = new UpdateQueue();
        for (Item item : this.items.values()) {
            queue.enqueue(item, priority);
        }
        return queue;
    }

    protected Item findAncestorByClass(Class c) {
        Item item = this;
        while (item != null) {
            if (item.getClass() == c) {
                return item;
            }
            item = item.parent;
        }
        return null;
    }

    protected boolean containsItem(Item item) {
        for (Item oldItem : this.items.values()) {
            if (item != oldItem) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getTrail().toDisplayString();
    }

    private static class Entry
    implements Comparable<Entry> {
        public final String name;
        public final Item item;
        public final Comparable cmpKey;

        public Entry(String name, Item item, Comparable cmpKey) {
            this.name = name;
            this.item = item;
            this.cmpKey = cmpKey;
        }

        @Override
        public int compareTo(Entry e) {
            return this.cmpKey.compareTo(e.cmpKey);
        }
    }
}

