/*
 * Decompiled with CFR 0.152.
 */
package fig.prob;

import fig.basic.Exceptions;
import fig.prob.Beta;
import fig.prob.BetaInterface;
import fig.prob.Distrib;
import fig.prob.SuffStats;
import java.util.Random;

public class DegenerateBeta
implements BetaInterface {
    private double value;

    public DegenerateBeta(double value) {
        this.value = value;
    }

    @Override
    public double logProb(SuffStats stats) {
        throw Exceptions.unsupported;
    }

    @Override
    public double logProbObject(Double x) {
        throw Exceptions.unsupported;
    }

    @Override
    public Double sampleObject(Random random) {
        return this.value;
    }

    @Override
    public double expectedLog(boolean b) {
        if (b) {
            return Math.log(this.value);
        }
        return Math.log(1.0 - this.value);
    }

    @Override
    public double crossEntropy(Distrib<Double> _that) {
        if (_that instanceof DegenerateBeta) {
            return 0.0;
        }
        Beta that = (Beta)_that;
        return that.logProb(this.value);
    }

    @Override
    public double getMean() {
        return this.value;
    }

    @Override
    public double getMode() {
        return this.value;
    }

    @Override
    public BetaInterface modeSpike() {
        return this;
    }

    @Override
    public double getAlpha() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double getBeta() {
        return Double.POSITIVE_INFINITY;
    }

    @Override
    public double totalCount() {
        return Double.POSITIVE_INFINITY;
    }

    public String toString() {
        return String.format("DegenerateBeta(%.3f)", this.value);
    }
}

