/*
 * Decompiled with CFR 0.152.
 */
package net.sf.epsgraphics;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import net.sf.epsgraphics.EpsGraphics;

final class EpsDocument {
    private OutputStream stream;
    private int minX;
    private int minY;
    private int maxX;
    private int maxY;
    private boolean _isClipSet = false;
    private String title;
    private BufferedWriter bufferedWriter = null;
    private EpsGraphics _lastG = null;

    EpsDocument(String string, OutputStream outputStream, int n, int n2, int n3, int n4) throws IOException {
        this.title = string;
        this.minX = n;
        this.minY = n2;
        this.maxX = n3;
        this.maxY = n4;
        this.bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream));
        this.stream = outputStream;
        this.write(this.bufferedWriter);
    }

    public synchronized String getTitle() {
        return this.title;
    }

    public synchronized void append(EpsGraphics epsGraphics, String string) {
        if (this._lastG == null) {
            this._lastG = epsGraphics;
        } else if (epsGraphics != this._lastG) {
            EpsGraphics epsGraphics2 = this._lastG;
            this._lastG = epsGraphics;
            if (epsGraphics.getClip() != epsGraphics2.getClip()) {
                epsGraphics.setClip(epsGraphics.getClip());
            }
            if (!epsGraphics.getColor().equals(epsGraphics2.getColor())) {
                epsGraphics.setColor(epsGraphics.getColor());
            }
            if (!epsGraphics.getBackground().equals(epsGraphics2.getBackground())) {
                epsGraphics.setBackground(epsGraphics.getBackground());
            }
            System.err.println("append g: " + epsGraphics.hashCode());
            System.err.println("append lastg: " + epsGraphics2.hashCode());
            if (!epsGraphics.getPaint().equals(epsGraphics2.getPaint())) {
                epsGraphics.setPaint(epsGraphics.getPaint());
            }
            if (epsGraphics.getComposite() != null && !epsGraphics.getComposite().equals(epsGraphics2.getComposite())) {
                epsGraphics.setComposite(epsGraphics.getComposite());
            }
            if (epsGraphics.getFont() != null && !epsGraphics.getFont().equals(epsGraphics2.getFont())) {
                epsGraphics.setFont(epsGraphics.getFont());
            }
            if (epsGraphics.getStroke() != null && !epsGraphics.getStroke().equals(epsGraphics2.getStroke())) {
                epsGraphics.setStroke(epsGraphics.getStroke());
            }
        }
        this._lastG = epsGraphics;
        try {
            this.bufferedWriter.write(string + "\n");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not write to the output file: " + iOException);
        }
    }

    public synchronized void write(Writer writer) throws IOException {
        float f = -this.minX;
        float f2 = -this.minY;
        writer.write("%!PS-Adobe-3.0 EPSF-3.0\n");
        writer.write("%%Creator: EpsGraphics 1.0.0 by Thomas Abeel, http://www.sourceforge.net/epsgraphics/\n");
        writer.write("%%Title: " + this.title + "\n");
        writer.write("%%CreationDate: " + new Date() + "\n");
        writer.write("%%BoundingBox: 0 0 " + (int)Math.ceil((float)this.maxX + f) + " " + (int)Math.ceil((float)this.maxY + f2) + "\n");
        writer.write("%%DocumentData: Clean7Bit\n");
        writer.write("%%LanguageLevel: 2\n");
        writer.write("%%DocumentProcessColors: Black\n");
        writer.write("%%ColorUsage: Color\n");
        writer.write("%%Origin: 0 0\n");
        writer.write("%%Pages: 1\n");
        writer.write("%%Page: 1 1\n");
        writer.write("%%EndComments\n\n");
        writer.write("gsave\n");
        writer.write(f + " " + ((float)this.maxY + f2) + " translate\n");
        writer.flush();
    }

    private void writeFooter(Writer writer) throws IOException {
        writer.write("grestore\n");
        if (this.isClipSet()) {
            writer.write("grestore\n");
        }
        writer.write("showpage\n");
        writer.write("\n");
        writer.write("%%EOF");
        writer.flush();
    }

    public synchronized void flush() throws IOException {
        this.bufferedWriter.flush();
    }

    public synchronized void close() throws IOException {
        this.writeFooter(this.bufferedWriter);
        this.bufferedWriter.flush();
        this.bufferedWriter.close();
    }

    public boolean isClipSet() {
        return this._isClipSet;
    }

    public void setClipSet(boolean bl) {
        this._isClipSet = bl;
    }

    public final int getMaxX() {
        return this.maxX;
    }

    public final int getMaxY() {
        return this.maxY;
    }

    public final int getMinX() {
        return this.minX;
    }

    public final int getMinY() {
        return this.minY;
    }

    public OutputStream getStream() {
        return this.stream;
    }
}

