/*
 * Decompiled with CFR 0.152.
 */
package jigsaw.syntax;

import java.io.Serializable;
import java.util.Collection;

public class Constituent<L>
implements Serializable {
    private static final long serialVersionUID = 1L;
    L label;
    int start;
    int end;

    public L getLabel() {
        return this.label;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getLength() {
        return this.end - this.start + 1;
    }

    public String toString() {
        return "<" + this.label + " : " + this.start + ", " + this.end + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Constituent)) {
            return false;
        }
        Constituent constituent = (Constituent)o;
        if (this.end != constituent.end) {
            return false;
        }
        if (this.start != constituent.start) {
            return false;
        }
        return !(this.label != null ? !this.label.equals(constituent.label) : constituent.label != null);
    }

    public int hashCode() {
        int result = this.label != null ? this.label.hashCode() : 0;
        result = 29 * result + this.start;
        result = 29 * result + this.end;
        return result;
    }

    public boolean crosses(Collection<Constituent<L>> constColl) {
        for (Constituent<L> c : constColl) {
            if (!this.crosses(c)) continue;
            return true;
        }
        return false;
    }

    public boolean crosses(Constituent<L> c) {
        return this.start < c.start && c.start <= this.end && this.end < c.end || c.start < this.start && this.start <= c.end && c.end < this.end;
    }

    public Constituent(L label, int start, int end) {
        this.label = label;
        this.start = start;
        this.end = end;
    }
}

