/*
 * Decompiled with CFR 0.152.
 */
package SyntaxUtils;

import LinguaView.syntax.CCGNode;
import LinguaView.syntax.CCGTerminalNode;
import SyntaxUtils.Sentence;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class SentenceForCCGParsing
extends Sentence {
    protected List<String> adds;
    String source;

    public SentenceForCCGParsing(CCGNode node) {
        this.source = node.source;
        this.adds = new ArrayList<String>();
        for (CCGTerminalNode cn : node.collectTerminalNodes()) {
            this.words.add(cn.word());
            this.poss.add(cn.modPOS());
            if (cn.additionalInfo == null) continue;
            this.adds.add(cn.additionalInfo);
        }
        if (this.adds.size() != this.words.size()) {
            if (this.adds.size() != 0) {
                System.err.println("Some nodes has no additional info");
            }
            this.adds = null;
        }
    }

    public String additionalInfo(int k) {
        if (this.adds == null) {
            return null;
        }
        if (k >= 0 && k < this.length()) {
            return this.adds.get(k);
        }
        if (k < 0) {
            return "#BOS#";
        }
        return "#EOS#";
    }

    protected SentenceForCCGParsing() {
    }

    public static List<SentenceForCCGParsing> readSents(String filename) throws IOException {
        return SentenceForCCGParsing.readSents(filename, true, "UTF-8");
    }

    public static List<SentenceForCCGParsing> readSents(String filename, boolean firstLineIsSource, String encoding) throws IOException {
        ArrayList<SentenceForCCGParsing> sents = new ArrayList<SentenceForCCGParsing>();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), encoding));
        String s = br.readLine();
        while (s != null) {
            String[] ss;
            if (s.trim().length() == 0) continue;
            SentenceForCCGParsing sent = new SentenceForCCGParsing();
            if (firstLineIsSource) {
                sent.source = s;
                s = br.readLine();
            }
            String[] stringArray = ss = s.split("\\s");
            int n = ss.length;
            int n2 = 0;
            while (n2 < n) {
                String wp = stringArray[n2];
                int x = wp.lastIndexOf(47);
                sent.words.add(wp.substring(0, x));
                sent.poss.add(wp.substring(x + 1));
                ++n2;
            }
            sents.add(sent);
            s = br.readLine();
        }
        br.close();
        return sents;
    }

    public static List<SentenceForCCGParsing> readSentsInColumn(String filename, boolean firstLineIsSource, String encoding) throws IOException {
        ArrayList<SentenceForCCGParsing> sents = new ArrayList<SentenceForCCGParsing>();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), encoding));
        String s = br.readLine();
        SentenceForCCGParsing sent = null;
        while (s != null) {
            if (s.trim().length() == 0) {
                if (sent != null) {
                    sents.add(sent);
                }
                sent = null;
            } else {
                if (sent == null) {
                    sent = new SentenceForCCGParsing();
                    if (firstLineIsSource) {
                        sent.source = s;
                        s = br.readLine();
                        continue;
                    }
                }
                String[] ss = s.split("\t");
                sent.words.add(ss[0]);
                sent.poss.add(ss[1]);
            }
            s = br.readLine();
        }
        br.close();
        return sents;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.source != null) {
            sb.append(String.valueOf(this.source) + "\n");
        }
        sb.append(super.toString());
        return sb.toString();
    }

    public String toColumnsString() {
        StringBuffer sb = new StringBuffer();
        if (this.source != null) {
            sb.append(String.valueOf(this.source) + "\n");
        }
        int i = 0;
        while (i < this.length()) {
            sb.append(String.valueOf(this.word(i)) + '\t' + this.pos(i) + '\n');
            ++i;
        }
        return sb.toString();
    }

    public static void main(String[] args) throws IOException {
        ArrayList<CCGNode> ccc = CCGNode.readCCGFile(new File(args[0]), "UTF-8");
        PrintWriter pw = new PrintWriter(args[1]);
        for (CCGNode cn : ccc) {
            SentenceForCCGParsing sent = new SentenceForCCGParsing(cn);
            pw.println(sent.toColumnsString());
        }
        pw.close();
    }
}

