#!/usr/bin/env python2.7
#coding=UTF-8
'''
Given lines with tab-separated fields for
* the sentence ID
* Arabic tokens
* tags 1 (may be empty)
* tags 2 (optional)

E.g. a tab-separated version of
00050001
كرة القدم رياضة جماعية ، يضم فريق كرة القدم 11 لاعبا بالإضافة إلى خمسة لاعبين للاحتياط . 
! < ! _ _ _ G ! < Q P _ _ Q P _ _ 
! < _ _ _ _ G ! < _ _ _ _ _ _ _ _

Produces a per-token output format with the fields
* Arabic token
* tag 1
* tag 2
'''
from __future__ import print_function, division
import sys, os, re, fileinput, codecs

for ln in fileinput.input(sys.argv[1:]):
    ln = ln[:-1]
    parts = ln.split('\t')
    if len(parts)==3:
        parts.append('')
    sentid, ttS, gg1S, gg2S = parts
    tt = ttS.split()
    gg1 = gg1S.split() if gg1S else ['']*len(tt)
    gg2 = gg2S.split() if gg2S else ['']*len(tt)
    if not len(tt)==len(gg1)==len(gg2):
        print('skipping {} due to tokenization mismatch'.format(sentid), file=sys.stderr)
        continue
    for t,g1,g2 in zip(tt,gg1,gg2):
        print(t,g1,g2, sentid, sep='\t')
    print()
