use strict;
use warnings;
use Data::Dumper;

die "Usage: perl test.pl wmf_vec neighbors.osp 1 02330245#n 05436752#n\n" if (@ARGV != 5);

my $vec_file = $ARGV[0];
my $nb_file = $ARGV[1];
my $nb_weight = $ARGV[2];
my $osp1 = $ARGV[3];
my $osp2 = $ARGV[4];

my %vectors;
my %nbs;

&initialize($vec_file, $nb_file, $nb_weight);
print "initilaization completed!\n";
print &get_sim($osp1, $osp2) . "\n";


sub initialize() {
    my ($vec_file, $nb_file, $wnb) = @_;

    ### 1. read nb file
    print "reading neighbor file...\n";
    my @osps;
    open(N, $nb_file) || die "Cannot open $nb_file\n";
    while (my $str = <N>) {
	$str =~ s/\s+$//;
	$str =~ s/(.+?):\s*//;
	my $osp = $1;
	push(@osps, $osp);
	my @nb = split(/\s+/, $str);
	$nbs{$osp} = \@nb;
    }
    close(N);


    
    ### 2. read wmf vector file
    print "reading vec file...\n";
    open(V, $vec_file) || die "Cannot open $vec_file\n";
    my $i = 0;
    while (my $str = <V>) {
	#print "" if ($i );
	my $osp = $osps[$i];
	$str =~ s/\s+$//;
	my @v = split(/\s+/, $str);
	$vectors{$osp} = \@v;
	$i++;
	if ($i == 117659) {
	    last;
	}
    }
    close(V);


    ### 4. sum over neighbors
    my %vector2;
    foreach my $osp (keys %vectors) {
	my $vec = $vectors{$osp};
	my $nbs = $nbs{$osp};
	my @new_vec = @$vec;
	foreach my $nb (@$nbs) {
	    my $nb_vec = $vectors{$nb};
	    for (my $i = 0; $i < @new_vec; $i++) {
		if (!defined $nb_vec->[$i]) {
		    print Dumper($nb_vec);
		    die "nb: $nb\n";
		}
		$new_vec[$i] += $wnb * $nb_vec->[$i];
	    }
	}
	$vector2{$osp} = \@new_vec;
    }
    %vectors = %vector2;
}





sub get_sim() {
    my ($osp1, $osp2) = @_;
    $osp1 = &add_0($osp1);
    $osp2 = &add_0($osp2);
    if (!exists $vectors{$osp1} || !exists $vectors{$osp2}) {
	die "$osp1 or $osp2 does not exists!\n";
    }
    my $v1 = $vectors{$osp1};
    my $v2 = $vectors{$osp2};
    my $sim = 0;
    for (my $i = 0; $i < @$v1; $i++) {
	$sim += $v1->[$i] * $v2->[$i];
    }
    return $sim;
}

sub add_0() {
    my ($osp) = @_;
    while (length($osp) < 10) {
	$osp = "0$osp";
    }
    return $osp;
}
