#    This is a part of the "NED", a dependency parsing evaluation tool developed
#    in the Hebrew University by Roy Schwartz, Omri Abend, Roi Reichart and Ari Rappoport.
#    Copyright (C) 2011  Omri Abend, Roi Reichart and Ari Rappoport
#
#    This program is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
#    If you have any questions, feel free to contact us in:
#    roys02@cs.huji.ac.il, omria01@cs.huji.ac.il, roiri@csail.mit.edu
#
#    Please read the README file for more details.
package ParseSentence;

use POS;
use strict;

sub new {
	my ($class, $poses, $model, $punctRE) = @_;

	my $self = {};

	if (defined $model) {
		my @posRefs = ();

		for (my $i = 0 ; $i < @{$poses} ; ++$i) {
			unless (defined ($poses->[$i])) {
				push(@posRefs, new POS(undef, $i+1, undef, undef));
			} elsif (POS::isPunct($poses->[$i], $punctRE)) {
				push(@posRefs, undef);
			} else {
				push(@posRefs, new POS($poses->[$i], $i+1, $model->{CONTEND}->{$poses->[$i]}, $model->{DEP}->{$poses->[$i]}));

			}
		}
		#map {new POS($_, $model->{CONTEND}->{$_}, $model->{DEP}->{$_}) } @{$poses};

		$self->{POSES} = \@posRefs;
		$self->{MODEL} = $model;
		$self->{DATA} = $poses;
		$self->{ROOT} = undef;
	} else {
		# copy ctor.
		my @posRefs =  map {new POS($_) } @{$poses->{POSES}};
		$self->{POSES} = \@posRefs;
		$self->{MODEL} = $poses->{MODEL};
		$self->{DATA} = $poses->{DATA};
		$self->{ROOT} = $poses->root();
	}

	bless($self, $class);

	return $self;
}

sub clone($) {
	my $self = shift;

	my $sent = new ParseSentence($self);

	return $sent;
}

sub addPosParent($$$) {
	my $self = shift;
	my $pos = shift;
	my $val = shift;

	my $posIndex = $pos-1;
	my $valIndex = $val-1;

	return if (not defined $self->{POSES}->[$posIndex]);

	$self->{POSES}->[$posIndex]->setParent($val);

	if ($pos < $val) {
		$self->{POSES}->[$valIndex]->addLeft($self->{POSES}->[$posIndex]);
	} elsif ($val != POS::ROOT) {
		$self->{POSES}->[$valIndex]->addRight($self->{POSES}->[$posIndex]);
	} else {
		if (defined $self->{ROOT}) {
			return undef;
		}
		$self->root($pos);
	}
}


sub posByIndex($$) {
	my $self = shift;
	my $index = shift;

	return $self->{POSES}->[$index - 1];
}

sub root($) {
	my $self = shift;

	my $root = shift;

	if (defined $root) {
		$self->{ROOT} = $self->{POSES}->[$root-1]->data();
	} elsif (not defined ($self->{ROOT})) {
		return undef;
	} else {
		return $self->{ROOT};
	}
}

sub toString($) {
	my $self = shift;

	my $s;

	foreach my $pos (@{$self->{POSES}}) {
		next unless defined $pos;
		$s .= $pos->toString().",";
	}

	chop($s);

	return $s;
}

sub parserOutput($) {
	my $self = shift;

	my $firstPart ="[".join(",", @{$self->{DATA}})."] ";
	my $secondPart = "[".join(",", map {$_->parent()} @{$self->{POSES}})."]";

	return  $firstPart.$secondPart;
}




1;