###############################################################################
##                                                                           ##
## This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. ##
##                                                                           ##
##    ModelBlocks is free software: you can redistribute it and/or modify    ##
##    it under the terms of the GNU General Public License as published by   ##
##    the Free Software Foundation, either version 3 of the License, or      ##
##    (at your option) any later version.                                    ##
##                                                                           ##
##    ModelBlocks is distributed in the hope that it will be useful,         ##
##    but WITHOUT ANY WARRANTY; without even the implied warranty of         ##
##    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          ##
##    GNU General Public License for more details.                           ##
##                                                                           ##
##    You should have received a copy of the GNU General Public License      ##
##    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   ##
##                                                                           ##
###############################################################################


require 'scripts/umnlp.rb'

class Tree
  def printUnfs
    if @children.size == 0
      return
    end
    
    if @head =~ /UNF$/ and not @head =~ /arg/
      #print "UNF #{@head.gsub(/^([^-]+).*$/, '\1')}"
      print "UN #{@head.sub(/^([A-Z$]+).*UNF/, '\1')}"
      @children.each{ |child|
        print " #{child.head.sub(/^([A-Z$]+).*/, '\1')}"
      }
      print "\n"
    end
    
    @children.each{ |child|
      child.printUnfs
    }
  end
end

while (line = $stdin.gets)
  t = Tree.new(line)
  t.printUnfs
end
