///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// This file is part of ModelBlocks. Copyright 2009, ModelBlocks developers. //
//                                                                           //
//    ModelBlocks is free software: you can redistribute it and/or modify    //
//    it under the terms of the GNU General Public License as published by   //
//    the Free Software Foundation, either version 3 of the License, or      //
//    (at your option) any later version.                                    //
//                                                                           //
//    ModelBlocks is distributed in the hope that it will be useful,         //
//    but WITHOUT ANY WARRANTY; without even the implied warranty of         //
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          //
//    GNU General Public License for more details.                           //
//                                                                           //
//    You should have received a copy of the GNU General Public License      //
//    along with ModelBlocks.  If not, see <http://www.gnu.org/licenses/>.   //
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef _SYNTACTICLMMODELFILES_H__
#define _SYNTACTICLMMODELFILES_H__

#include "nl-iomacros.h"
#include "nl-string.h"

template <class MH, class MO> 
class SyntacticLMModelFiles {

 public:

  SyntacticLMModelFiles(const std::vector<std::string>& filePaths);
  ~SyntacticLMModelFiles();
  
  MH* getHiddenModel();
  MO* getObservedModel();

 private:
  MH* hiddenModel;
  MO* observedModel;
  
};


template <class MH, class MO>
  SyntacticLMModelFiles<MH,MO>::SyntacticLMModelFiles(const std::vector<std::string>& filePaths) {

  this->hiddenModel = new MH();
  this->observedModel = new MO();
  
  //// I. LOAD MODELS...
  std::cerr << "Reading syntactic language model files...\n";
  // For each model file...
  for ( int a=0, n=filePaths.size(); a<n; a++ ) {                                           // read models
    FILE* pf = fopen(filePaths[a].c_str(),"r"); assert(pf);                                   // Read model file
    if(!pf){
      std::cerr << "Error loading model file " << filePaths[a] << std::endl;
      return;
    }
    std::cerr << "Loading model \'" << filePaths[a] << "\'...\n";
    int c=' '; int i=0; int line=1; String sBuff(1000);                          // Lookahead/ctrs/buffers
    CONSUME_ALL ( pf, c, WHITESPACE(c), line);                                   // Get to first record
    while ( c!=-1 && c!='\0' && c!='\5' ) {                                      // For each record
      CONSUME_STR ( pf, c, (c!='\n' && c!='\0' && c!='\5'), sBuff, i, line );    //   Consume line
      StringInput si(sBuff.c_array());
      if ( !( sBuff[0]=='#'                                                   //   Accept comments/fields
			  ||  si>>*(this->hiddenModel)>>"\0"!=NULL 
			  ||  si>>*(this->observedModel)>>"\0"!=NULL
			  ))								   
	std::cerr<<"\nERROR: can't parse \'"<<sBuff<<"\' in line "<<line<<"\n\n";
      CONSUME_ALL ( pf, c, WHITESPACE(c), line);                                 //   Consume whitespace
      if ( line%100000==0 ) std::cerr<<"  "<<line<<" lines read...\n";                //   Progress for big models
    }
    std::cerr << "Model \'" << filePaths[a] << "\' loaded.\n";
  }

  std::cerr << "...reading syntactic language model files completed\n";


}


template <class MH, class MO>
  SyntacticLMModelFiles<MH,MO>::~SyntacticLMModelFiles() {

  delete hiddenModel;
  delete observedModel;

}


template <class MH, class MO>
  MH* SyntacticLMModelFiles<MH,MO>::getHiddenModel() {
 
  return this->hiddenModel;

}

template <class MH, class MO>
  MO* SyntacticLMModelFiles<MH,MO>::getObservedModel() {
 
  return this->observedModel;

}

#endif
