/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.noplanar;

import java.util.SortedSet;
import java.util.Stack;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.core.syntaxgraph.edge.Edge;
import org.maltparser.core.syntaxgraph.node.DependencyNode;
import org.maltparser.parser.ParserConfiguration;
import org.maltparser.parser.TransitionSystem;
import org.maltparser.parser.algorithm.noplanar.NoPlanarConfig;
import org.maltparser.parser.history.GuideUserHistory;
import org.maltparser.parser.history.History;
import org.maltparser.parser.history.action.ComplexDecisionAction;
import org.maltparser.parser.history.action.GuideUserAction;
import org.maltparser.parser.transition.TransitionTable;

public class NoPlanar
extends TransitionSystem {
    protected static final int SHIFT = 1;
    protected static final int REDUCE = 2;
    protected static final int RIGHTARC = 3;
    protected static final int LEFTARC = 4;

    public void apply(GuideUserAction currentAction, ParserConfiguration config) throws MaltChainedException {
        NoPlanarConfig planarConfig = (NoPlanarConfig)config;
        Stack<DependencyNode> stack = planarConfig.getStack();
        Stack<DependencyNode> input = planarConfig.getInput();
        currentAction.getAction(this.actionContainers);
        Edge e = null;
        switch (this.transActionContainer.getActionCode()) {
            case 4: {
                e = planarConfig.getDependencyStructure().addDependencyEdge(input.peek().getIndex(), stack.peek().getIndex());
                this.addEdgeLabels(e);
                break;
            }
            case 3: {
                e = planarConfig.getDependencyStructure().addDependencyEdge(stack.peek().getIndex(), input.peek().getIndex());
                this.addEdgeLabels(e);
                break;
            }
            case 2: {
                stack.pop();
                break;
            }
            default: {
                stack.push(input.pop());
            }
        }
    }

    public GuideUserAction getDeterministicAction(GuideUserHistory history, ParserConfiguration config) throws MaltChainedException {
        NoPlanarConfig planarConfig = (NoPlanarConfig)config;
        if (planarConfig.getRootHandling() != 3 && planarConfig.getStack().peek().isRoot()) {
            return this.updateActionContainers(history, 1, null);
        }
        return null;
    }

    protected void addAvailableTransitionToTable(TransitionTable ttable) throws MaltChainedException {
        ttable.addTransition(1, "SH", false, null);
        ttable.addTransition(2, "RE", false, null);
        ttable.addTransition(3, "RA", true, null);
        ttable.addTransition(4, "LA", true, null);
    }

    protected void initWithDefaultTransitions(GuideUserHistory history) throws MaltChainedException {
        ComplexDecisionAction currentAction = new ComplexDecisionAction((History)history);
        this.transActionContainer.setAction(1);
        this.transActionContainer.setAction(2);
        for (int i = 0; i < this.arcLabelActionContainers.length; ++i) {
            this.arcLabelActionContainers[i].setAction(-1);
        }
        currentAction.addAction(this.actionContainers);
    }

    public String getName() {
        return "noplanar";
    }

    public boolean permissible(GuideUserAction currentAction, ParserConfiguration config) throws MaltChainedException {
        currentAction.getAction(this.actionContainers);
        int trans = this.transActionContainer.getActionCode();
        NoPlanarConfig planarConfig = (NoPlanarConfig)config;
        DependencyNode stackPeek = planarConfig.getStack().peek();
        DependencyNode inputPeek = planarConfig.getInput().peek();
        DependencyStructure dg = planarConfig.getDependencyGraph();
        int rootHandling = planarConfig.getRootHandling();
        boolean singleHeadConstraint = planarConfig.requiresSingleHead();
        boolean noCoveredRootsConstraint = planarConfig.requiresNoCoveredRoots();
        boolean acyclicityConstraint = planarConfig.requiresAcyclicity();
        boolean connectednessConstraintOnReduce = planarConfig.requiresConnectednessCheckOnReduce();
        boolean connectednessConstraintOnShift = planarConfig.requiresConnectednessCheckOnShift();
        if (!(trans != 4 && trans != 3 || this.isActionContainersLabeled())) {
            return false;
        }
        if (trans == 4) {
            if (stackPeek.isRoot()) {
                return false;
            }
            if (stackPeek.hasHead() && this.getConcreteEdgeGraph(dg, inputPeek.getIndex(), stackPeek.getIndex(), this.getLabelActionString(currentAction)) != null) {
                return false;
            }
        }
        if (trans == 3 && inputPeek.hasHead() && this.getConcreteEdgeGraph(dg, stackPeek.getIndex(), inputPeek.getIndex(), this.getLabelActionString(currentAction)) != null) {
            return false;
        }
        if (trans == 2) {
            if (stackPeek.isRoot()) {
                return false;
            }
            if (!stackPeek.hasHead() && noCoveredRootsConstraint) {
                return false;
            }
            if (connectednessConstraintOnReduce) {
                DependencyNode stackPrev;
                boolean path1;
                boolean bl = path1 = stackPeek.findComponent().getIndex() == inputPeek.findComponent().getIndex();
                boolean path2 = planarConfig.getStack().size() < 2 ? false : (stackPrev = (DependencyNode)planarConfig.getStack().get(planarConfig.getStack().size() - 2)).findComponent().getIndex() == stackPeek.findComponent().getIndex();
                return path1 || path2;
            }
        }
        if (trans == 2 && !stackPeek.hasHead() && rootHandling == 1) {
            return false;
        }
        if (trans == 1 && connectednessConstraintOnShift && planarConfig.getInput().size() == 1) {
            boolean path = planarConfig.getDependencyGraph().getTokenNode(1).findComponent().getIndex() == inputPeek.findComponent().getIndex();
            return path;
        }
        return true;
    }

    public GuideUserAction defaultAction(GuideUserHistory history, ParserConfiguration configuration) throws MaltChainedException {
        return this.updateActionContainers(history, 1, null);
    }

    private Edge getConcreteEdgeGraph(DependencyStructure dg, int index1, int index2, String label) throws MaltChainedException {
        SortedSet<Edge> arcos = dg.getEdges();
        for (Edge arco : arcos) {
            if (arco.getSource().getIndex() != index1 || arco.getTarget().getIndex() != index2 || arco.getLabelSymbol(dg.getSymbolTables().getSymbolTable("DEPREL")).compareTo(label) != 0) continue;
            return arco;
        }
        return null;
    }
}

