from api.azure_api_manager import AzureCaller, AzureApiConfig, Prompt
from tqdm import tqdm
import time


class TaskManager:
    def __init__(self, task_name=None):
        self.task_name = task_name
        self.azure_api_config = AzureApiConfig()
        self.caller = AzureCaller(self.azure_api_config)

    def single_query_request(self, instruction, inputs):
        prompt = Prompt()
        prompt.build_prompt_obj(instruction, inputs)
        try:
            print("Requesting...")
            s = time.time()
            res = self.caller.chat_completion(prompt)
            result = res.get("choices", [{}])[0].get("message", {}).get("content", "")
            print("Received. Cost", time.time() - s)
            pass
        except Exception as e:
            print("error", e, inputs)
            return ""
        return result

    def single_process_run(self, input_prompt_list, output_result, version=None):
        for each in tqdm(input_prompt_list):
            if not version:
                version = "(0403_v0)"
            key = each.input_content + version
            if key in output_result:
                # print(key, "has been called before, jump it")
                continue
            try:
                res = self.caller.chat_completion(each)
            except Exception as e:
                res = {}
                print("error", e)
            result = res.get("choices", [{}])[0].get("message", {}).get("content", "")
            if result:
                output_result[key] = result
            else:
                print("result is None", key)
        return output_result






