# -*- coding: utf-8 -*-
"""run_probe_clean.ipynb

Automatically generated by Colab.

Original file is located at
    https://colab.research.google.com/drive/16tB6AzzT9_Enq_s17NBTknAbZMTq-7PG

# Prepare data
"""

import pandas as pd

df_raw = pd.read_csv(f'/content/drive/MyDrive/LLM_role-reversal/data/df_comb.csv')

# Melt the DataFrame
melted_sentence = df_raw.melt(id_vars=["exp","item", "type", "plausibility"], value_vars=["sentence"], var_name="variable", value_name="sentences")
# Pivot the DataFrame to get implaus_sent and plaus_sent columns
pivoted_sentence = melted_sentence.pivot_table(index=["exp","item","type"], columns="plausibility", values="sentences", aggfunc='first').reset_index()
pivoted_sentence.columns = ["exp","item", "type","implaus_sent", "plaus_sent"]

# Melt the DataFrame
melted_target = df_raw.melt(id_vars=["exp","item", "type", "plausibility"], value_vars=["target"], var_name="variable", value_name="targets")
# Pivot the DataFrame to get implaus_target and plaus_target columns
pivoted_target = melted_target.pivot_table(index=["exp","item","type"], columns="plausibility", values="targets", aggfunc='first').reset_index()
pivoted_target.columns = ["exp","item", "type","implaus_target", "plaus_target"]

df_temp = pd.merge(pivoted_sentence,df_raw[["exp","item", "type"]],how='left',on=["exp","item", "type"]).drop_duplicates()
df = pd.merge(pivoted_target,df_temp[["exp","item", "type",'implaus_sent','plaus_sent']],how='left',on=["exp","item", "type"]).drop_duplicates()

WY_rev = df[(df['exp'] == 'WY') & (df['type'] == 'reversal')]
LE_rev = df[(df['exp'] == 'LE') & (df['type'] == 'reversal')]
KO_rev = df[(df['exp'] == 'KO') & (df['type'] == 'reversal')]
WY_sub = df[(df['exp'] == 'WY') & (df['type'] == 'substitution')]
WY_con = df[(df['exp'] == 'WY') & (df['type'] == 'control')]
LE_alt = df[(df['exp'] == 'LE') & (df['type'] == 'alternative')]
KO_con = df[(df['exp'] == 'KO') & (df['type'] == 'control')]
WY_LE_rev_comb = pd.concat([WY_rev, LE_rev], ignore_index=True)
WY_KO_con_comb = pd.concat([WY_con, KO_con], ignore_index=True)

"""# Run probe on verb embeddings"""

import json
import probe

experiments = [
    (WY_rev, "WY_rev"),
    (LE_rev, "LE_rev"),
    (KO_rev, "KO_rev"),
    (WY_sub, "WY_sub")
]

model_layers = {
    'gpt2': 12,
    'gpt2-medium': 24,
    'bert-large-uncased' : 24,
    'roberta-large' : 24
}

def main():
    for experiment, experiment_name in experiments:
      for model_name in model_layers.keys():
          model = probe.load_model(model_name)
          print(f"Loaded {model_name}")
          probe_results = run_probe(model, model_layers[model_name], experiment, prep_fn)
          write_results(probe_results, f'/content/drive/MyDrive/LLM_role-reversal/results/probe_{experiment_name}_{model_name}.json')

def prep_fn(row):
    stimuli = [f"{row['plaus_sent']}",
               f"{row['implaus_sent']}"]
    labels = [0, 1]  # plausible is 0, implausible is 1
    verbs = [f"{row['plaus_target']}",
             f"{row['implaus_target']}"]
    return stimuli, labels, verbs

def check_stimuli_contains_verb(stimuli, verbs):
    for stimulus, verb in zip(stimuli, verbs):
        if verb not in stimulus:
            print(f"Error: Verb '{verb}' not found in stimulus '{stimulus}'")

def process_data(df, prep_fn):
    stimuli, labels, verbs = [], [], []
    for _, row in df.iterrows():
        row_stimuli, row_labels, row_verbs = prep_fn(row)
        check_stimuli_contains_verb(row_stimuli, row_verbs)
        stimuli += row_stimuli
        labels += row_labels
        verbs += row_verbs
    return stimuli, labels, verbs

def run_probe(model, layers, df, prep_fn):
    stimuli, labels, verbs = process_data(df, prep_fn)
    probing_results = {}
    for layer in range(1, layers + 1):
        embeddings = probe.extract_verb_embeddings(model, stimuli, verbs, layer)
        print("Finished with embeddings, running classifier")
        cv_results = probe.run_probing(embeddings, labels)
        print(f"Accuracy scores for 10-fold CV in layer {layer}: {cv_results}")
        probing_results[layer] = cv_results
    return probing_results

def write_results(probing_results, output_path):
    print(f"Finished probing, writing JSON of results to {output_path}")
    with open(output_path, 'w') as fp:
        json.dump(probing_results, fp)

if __name__ == "__main__":
    main()

"""# Plot probing accuracy results"""

import matplotlib.pyplot as plt
import pandas as pd
import json
import seaborn as sns
import numpy as np
sns.set(font_scale=2)
sns.set_palette('colorblind')

model_names = ['gpt2', 'gpt2-medium', 'bert-large-uncased','roberta-large' ]
experiment_names = ["WY_rev","LE_rev","KO_rev","WY_sub","WY_con","LE_alt","KO_con","WY_LE_rev_comb","WY_KO_con_comb"]

results = {}
for model_name in model_names:
  for experiment_name in experiment_names:
      file_path = f'/content/drive/MyDrive/LLM_role-reversal/results/probe_{experiment_name}_{model_name}.json'
      with open(file_path, 'r') as file:
          key = f"{experiment_name}_{model_name}"
          results[key] = json.load(file)

# Access the results using the keys, for example:
# print(results['WY_rev_gpt2'])

def plot_CSLP(ax, probe_data1, probe_data2, probe_data3, title):
    mean1 = probe_data1.groupby('Layer')['Accuracy'].mean()
    sem1 = probe_data1.groupby('Layer')['Accuracy'].sem()
    line1, = ax.plot(mean1.index, mean1, label='swap-arguments', color='blue')
    ax.fill_between(mean1.index, mean1 - sem1, mean1 + sem1, color='blue', alpha=0.3)

    mean2 = probe_data2.groupby('Layer')['Accuracy'].mean()
    sem2 = probe_data2.groupby('Layer')['Accuracy'].sem()
    line2, = ax.plot(mean2.index, mean2, label='change-verb', color='green')
    ax.fill_between(mean2.index, mean2 - sem2, mean2 + sem2, color='green', alpha=0.3)

    mean3 = probe_data3.groupby('Layer')['Accuracy'].mean()
    sem3 = probe_data3.groupby('Layer')['Accuracy'].sem()
    line3, = ax.plot(mean3.index, mean3, label='replace-argument', color='orange')
    ax.fill_between(mean3.index, mean3 - sem3, mean3 + sem3, color='orange', alpha=0.3)

    ax.axhline(y=0.5, color='gray', linestyle='--', linewidth=1)

    ax.set_title(title, fontsize=20)
    ax.grid(True)

    return line1, line2, line3


fig, axes = plt.subplots(1, 4, figsize=(20, 6), sharey=True)

df1 = "WY_rev"
df2 = "KO_rev"
df3 = "WY_sub"

models = [
    ('gpt2', 'GPT2-small'),
    ('gpt2-medium', 'GPT2-medium'),
    ('bert-large-uncased', 'BERT-large'),
    ('roberta-large', 'RoBERTa-large')
]

lines = []
labels = []
for ax, (model_name, title) in zip(axes, models):
    probe_data1 = pd.DataFrame(results[f'{df1}_{model_name}']).melt()
    probe_data1.columns = ['Layer', 'Accuracy']
    probe_data1['Layer'] = probe_data1['Layer'].astype(int)

    probe_data2 = pd.DataFrame(results[f'{df2}_{model_name}']).melt()
    probe_data2.columns = ['Layer', 'Accuracy']
    probe_data2['Layer'] = probe_data2['Layer'].astype(int)

    probe_data3 = pd.DataFrame(results[f'{df3}_{model_name}']).melt()
    probe_data3.columns = ['Layer', 'Accuracy']
    probe_data3['Layer'] = probe_data3['Layer'].astype(int)

    line1, line2, line3 = plot_CSLP(ax, probe_data1, probe_data2, probe_data3, title)
    lines.extend([line1, line2, line3])
    labels.extend(['swap-arguments','change-verb','replace-argument'])

    ax.tick_params(axis='both', which='major', labelsize=20)
    ax.tick_params(axis='both', which='minor', labelsize=20)

    xticks = list(range(0, max(probe_data1['Layer']) + 1, 4))
    ax.set_xticks(xticks)
    ax.set_ylim(.45, 1.05)
    ax.set_xlabel('')
    ax.set_ylabel('')

fig.legend(lines[:3], labels[:3], loc='center left', bbox_to_anchor=(.85, 0.5), fontsize=20, title='Condition')
fig.text(0.5, 0.01, 'Layer', ha='center', va='center', fontsize=20)
fig.text(0.04, 0.5, 'Accuracy', ha='center', va='center', rotation='vertical', fontsize=20)
plt.tight_layout(rect=[0.05, 0.02, 0.85, 0.96])
plt.show()
