# Finetuning LLaMA on commonsense reasoning tasks using LoRA+IST


This directory includes the IST implementation and guidelines for reproducing the results in our paper.

## Setup
1. Install dependencies
```bash
conda create -n dora_llama python=3.10
conda activate dora_llama
pip install -r requirements.txt
```

## Datasets
1. Download the complete commonsense datasets from [here](https://github.com/AGI-Edgerunners/LLM-Adapters/tree/main/dataset) and download the commonsense 170k finetuning dataset from [here](https://github.com/AGI-Edgerunners/LLM-Adapters/blob/main/ft-training_set/commonsense_170k.json), then organize the data as follows
```bash
# Store the complete commonsense datasets
./dataset
# rest of the files
./experiment
./peft
# Finetuning commonsense dataset
./commonsense_170k.json
...
```

## Code Structure

Refer to `./ist.py` for the implementation of IST.

Refer to `./finetune.py` for finetuning LLaMA with LoRA+IST.

Refer to `./commonsense_evaluate.py` for the evaluation of the finetuned model.

## Finetuning and Evaluation

### Finetuning (`./llama_7B_lora_ist_train.sh`)
An example could be:
```
sh llama_7B_lora_ist_train.sh ./finetuned_result/lora_ist_r32 0
```
### Evaluation

An example could be:
```
sh llama_7B_lora_ist_eval.sh ./finetuned_result/lora_ist_r32 0
```
## Acknowledgement
We greatly appreciate the contributions of two remarkable repositories: [LLM-Adapter](https://github.com/AGI-Edgerunners/LLM-Adapters), [PEFT](https://github.com/huggingface/peft). These projects have significantly benefited our work.

