from .openai_utils import chatgpt_chatbot_finalfeedback, join_hist


def prompt(transcript):
    return """Given the negotiation transcript: {}


        Your goal is to to build a constructive feedback to a user in order to them reaching a better outcome if they had to go over this
        negotiation again. You will focus on the linguistics aspect and strategic aspects and dont bother with discussing the prices offered.
        You are adressing directly to the buyer, use the second person (You).
        Here are the dimensions your feedback will include:

        - Formality: A buyer cannot be rude and pushy. Also a good buyer stays polite. 
        - Firmness: A buyer cannot be too emotional. Studied have shown that firm and tough levels of communication help reaching better economic outcome than warmth and too friendly.
        - Linguistic level: A buyer should not be apologizing. Buyer do not say the word “greedy” (can be interpretated as a personal attack).
        As a buyer you should project that you do not need to buy a car/you have a perfectly good alternative/
                            The buyer also should somehow mention that they have a plan B.
        
        Feedback:""".format(
        transcript
    )


def generate_feedback(conversation):

    conversation = join_hist(conversation)

    with open("feedback_module/system_prompt_feedback.txt", "r") as file:
        instructions = file.read()

    messages = [
        {"role": "system", "content": instructions},
        {"role": "user", "content": prompt(conversation)},
    ]
    answer = chatgpt_chatbot_finalfeedback(messages=messages)

    return answer
