import fire
import json
from tqdm import tqdm
from openai_access import call_chatgpt


def input_prompt(
    question,
):
    return f"""### Python Question:
{question}

### Correct Solution:
"""


def main(
    input_path="",
    output_path="",
    sys_path="",
    start_index=0,
    end_index=100000,
    api_key=None,
    temp=0.7,
    max_tokens=2048,
):
    all_objs = json.load(open(input_path, "r"))[start_index:end_index]
    with open(sys_path, 'r', encoding='utf-8') as infile:
        sys_prompt = infile.read()
    rep_objs = []
    for cur_obj in tqdm(all_objs):
        question = cur_obj['instruction'].strip()
        task_id = cur_obj["task_id"]
        prompt = input_prompt(question)
        ans = call_chatgpt(prompt, temp, max_tokens, api_key, sys_prompt)
        rep_objs.append(
            {"task_id": task_id, "instruction": question, "output": ans}
        )
        json.dump(rep_objs, open(output_path, "w"), indent=4)

fire.Fire(main)