/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.tokensregex.SequenceMatchResult;
import edu.stanford.nlp.ling.tokensregex.SequenceMatcher;
import edu.stanford.nlp.ling.tokensregex.SequencePattern;
import edu.stanford.nlp.util.Filter;
import java.util.Arrays;
import java.util.List;

public interface SequenceMatchAction<T> {
    public SequenceMatchResult<T> apply(SequenceMatchResult<T> var1, int ... var2);

    public static final class SeriesAction<T>
    implements SequenceMatchAction<T> {
        List<SequenceMatchAction<T>> actions;

        public SeriesAction(SequenceMatchAction<T> ... actions) {
            this.actions = Arrays.asList(actions);
        }

        public SeriesAction(List<SequenceMatchAction<T>> actions) {
            this.actions = actions;
        }

        @Override
        public SequenceMatchResult<T> apply(SequenceMatchResult<T> seqMatchResult, int ... groups) {
            SequenceMatchResult<T> res = seqMatchResult;
            for (SequenceMatchAction<T> a : this.actions) {
                res = a.apply(res, groups);
            }
            return res;
        }
    }

    public static final class BranchAction<T>
    implements SequenceMatchAction<T> {
        Filter<SequenceMatchResult<T>> filter;
        SequenceMatchAction<T> acceptBranch;
        SequenceMatchAction<T> rejectBranch;

        public BranchAction(Filter<SequenceMatchResult<T>> filter, SequenceMatchAction<T> acceptBranch, SequenceMatchAction<T> rejectBranch) {
            this.filter = filter;
            this.acceptBranch = acceptBranch;
            this.rejectBranch = rejectBranch;
        }

        @Override
        public SequenceMatchResult<T> apply(SequenceMatchResult<T> seqMatchResult, int ... groups) {
            if (this.filter.accept(seqMatchResult)) {
                return this.acceptBranch != null ? this.acceptBranch.apply(seqMatchResult, new int[0]) : null;
            }
            return this.rejectBranch != null ? this.rejectBranch.apply(seqMatchResult, new int[0]) : null;
        }
    }

    public static final class NextMatchAction<T>
    implements SequenceMatchAction<T> {
        @Override
        public SequenceMatchResult<T> apply(SequenceMatchResult<T> seqMatchResult, int ... groups) {
            if (seqMatchResult instanceof SequenceMatcher) {
                SequenceMatcher matcher = (SequenceMatcher)seqMatchResult;
                if (matcher.find()) {
                    return matcher;
                }
                return null;
            }
            return null;
        }
    }

    public static final class StartMatchAction<T>
    implements SequenceMatchAction<T> {
        SequencePattern<T> pattern;

        public StartMatchAction(SequencePattern<T> pattern) {
            this.pattern = pattern;
        }

        @Override
        public SequenceMatchResult<T> apply(SequenceMatchResult<T> seqMatchResult, int ... groups) {
            SequenceMatcher<T> matcher = this.pattern.getMatcher(seqMatchResult.elements());
            if (matcher.find()) {
                return matcher;
            }
            return null;
        }
    }

    public static final class BoundAction<T> {
        SequenceMatchAction<T> action;
        int[] groups;

        public SequenceMatchResult<T> apply(SequenceMatchResult<T> seqMatchResult) {
            return this.action.apply(seqMatchResult, this.groups);
        }
    }
}

