/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ie.crf;

import edu.stanford.nlp.ie.crf.CRFCliqueTree;
import edu.stanford.nlp.ie.crf.LabelDictionary;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.sequences.SequenceModel;
import edu.stanford.nlp.util.CoreMap;
import java.util.List;

public class TestSequenceModel
implements SequenceModel {
    private final int window;
    private final int numClasses;
    private final CRFCliqueTree cliqueTree;
    private final int[] backgroundTag;
    private final int[] allTags;
    private int[][] allowedTagsAtPosition;

    public TestSequenceModel(CRFCliqueTree cliqueTree) {
        this(cliqueTree, null, null);
    }

    public TestSequenceModel(CRFCliqueTree<String> cliqueTree, LabelDictionary labelDictionary, List<? extends CoreMap> document) {
        int i;
        this.cliqueTree = cliqueTree;
        this.window = cliqueTree.window();
        this.numClasses = cliqueTree.getNumClasses();
        this.backgroundTag = new int[]{cliqueTree.backgroundIndex()};
        this.allTags = new int[this.numClasses];
        for (i = 0; i < this.allTags.length; ++i) {
            this.allTags[i] = i;
        }
        if (labelDictionary != null) {
            this.allowedTagsAtPosition = new int[document.size()][];
            for (i = 0; i < this.allowedTagsAtPosition.length; ++i) {
                CoreMap token = document.get(i);
                String observation = (String)token.get(CoreAnnotations.TextAnnotation.class);
                this.allowedTagsAtPosition[i] = labelDictionary.isConstrained(observation) ? labelDictionary.getConstrainedSet(observation) : this.allTags;
            }
        }
    }

    @Override
    public int length() {
        return this.cliqueTree.length();
    }

    @Override
    public int leftWindow() {
        return this.window - 1;
    }

    @Override
    public int rightWindow() {
        return 0;
    }

    @Override
    public int[] getPossibleValues(int pos) {
        if (pos < this.leftWindow()) {
            return this.backgroundTag;
        }
        int realPos = pos - this.window + 1;
        return this.allowedTagsAtPosition == null ? this.allTags : this.allowedTagsAtPosition[realPos];
    }

    @Override
    public double scoreOf(int[] tags, int pos) {
        int[] previous = new int[this.window - 1];
        int realPos = pos - this.window + 1;
        for (int i = 0; i < this.window - 1; ++i) {
            previous[i] = tags[realPos + i];
        }
        return this.cliqueTree.condLogProbGivenPrevious(realPos, tags[pos], previous);
    }

    @Override
    public double[] scoresOf(int[] tags, int pos) {
        int[] allowedTags = this.getPossibleValues(pos);
        int realPos = pos - this.window + 1;
        int[] previous = new int[this.window - 1];
        for (int i = 0; i < this.window - 1; ++i) {
            previous[i] = tags[realPos + i];
        }
        double[] scores = new double[allowedTags.length];
        for (int i = 0; i < allowedTags.length; ++i) {
            scores[i] = this.cliqueTree.condLogProbGivenPrevious(realPos, allowedTags[i], previous);
        }
        return scores;
    }

    @Override
    public double scoreOf(int[] sequence) {
        throw new UnsupportedOperationException();
    }
}

