import os
import json
import requests
from tqdm import tqdm
from openai import OpenAI
from concurrent.futures import ThreadPoolExecutor, as_completed, TimeoutError


n_threads = 40
n_prompts = 100
img_dir = 'gpt3.5_dalle2'
model = 'dall-e-2'
os.environ['OPENAI_API_KEY'] = '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'

client = OpenAI()

with open('../prompts_nobj.json', 'r', encoding='utf-8') as f:
    prompts = json.load(f)[:n_prompts]

def download_image(prompt, i):
    if os.path.exists(f'{img_dir}/{i}.jpg'):
        return
    response = client.images.generate(
        model=model,
        prompt=prompt,
        size='1024x1024',
        quality='standard',
        n=1,
    )
    image_url = response.data[0].url
    resp = requests.get(image_url)
    with open(f'{img_dir}/{i}.jpg', 'wb') as f:
        f.write(resp.content)


if __name__ == '__main__':
    os.makedirs(img_dir, exist_ok=True)
    progress_bar = tqdm(total=len(prompts))
    with ThreadPoolExecutor(max_workers=n_threads) as executor:
        futures = [executor.submit(download_image, prompt, i) for i, prompt in enumerate(prompts)]
        for future in as_completed(futures):
            progress_bar.update(1)
