"""
    utility for pandas dataframe wrangling
"""
import pandas as pd


def create_condition(df, column1, column2, list1, list2):
    """ generated by GPT4 on 2024-01-19 15:53
    Create a combined condition for filtering a DataFrame.

    :param df: Pandas DataFrame
    :param column1: Name of the first column to check
    :param column2: Name of the second column to check
    :param list1: List containing values for column1
    :param list2: List of lists containing values for column2
    :return: Boolean Series representing the combined condition
    """
    if len(list1) != len(list2):
        raise ValueError("Length of list1 and list2 must be equal")

    condition = pd.Series([False] * len(df))
    for item1, sublist2 in zip(list1, list2):
        condition |= ((df[column1] == item1) & df[column2].isin(sublist2))

    return condition
