theory question_81_10
imports Main

begin

typedecl entity
typedecl event

consts
  Soil :: "entity ⇒ bool"
  Nonliving :: "entity ⇒ bool"
  PartOf :: "entity ⇒ entity ⇒ bool"
  ForestEnvironment :: "entity"

theorem hypothesis:
  assumes asm: "Soil x"
  (* Hypothesis: Soil is a nonliving part of a forest. *)
  shows "Nonliving x ∧ PartOf x ForestEnvironment"
proof -
  from asm have "Soil x ⟶ Nonliving x" by (rule explanation_3)
  then have "Nonliving x" by simp
  have "PartOf x ForestEnvironment" using asm explanation_1 by (blast elim: PartOf.represent)
  then have "∃f. PartOf x f ∧ f = ForestEnvironment" by (rule PartOf_represent_forest)
  then have "PartOf x (the_forest ForestEnvironment)" by (rule the_forest_def)
  have "the_forest ForestEnvironment ∈ forest" using explanation_2 by simp
  then have "the_forest ForestEnvironment = ForestEnvironment" by (simp add: forest_def)
  have "PartOf x ForestEnvironment" by simp
  show ?thesis by (rule andI)
qed

end
