theory question_71_0
```
imports Main

begin

typedecl entity
typedecl event

consts
  Help :: "event ⇒ bool"
  ToBeUsedForSomething :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  DoSomething :: "entity ⇒ bool"
  Radio :: "entity ⇒ bool"
  Used :: "event ⇒ bool"
  Communication :: "entity ⇒ bool"
  FindingInformation :: "entity ⇒ bool"
  SharingInformation :: "entity ⇒ bool"
  Kind :: "entity ⇒ entity ⇒ bool"
  Tools :: "entity ⇒ bool"

(* Explanation 1: Help(e)  <=>  ToBeUsedForSomething(f)  ^^  Agent(f, g)  ^^  Patient(f, h)  ^^  DoSomething(h) *)
axiomatization where
  explanation_1: "Help e  <=>  ToBeUsedForSomething f  ^^  Agent f g  ^^  Patient f h  ^^  DoSomething h"

(* Explanation 2: Radio(i) ^^ Used(e) ^^ Agent(e, i) ^^ Communication(j)  -->  Patient(e, j) *)
axiomatization where
  explanation_2: "Radio i  ^^  Used e  ^^  Agent e i  ^^  Communication j  -->  Patient e j"

(* Explanation 3: Computer(k) ^^ Used(e) ^^ Agent(e, k) ^^ (Communication(j) || FindingInformation(j))  -->  Patient(e, j) *)
axiomatization where
  explanation_3: "Computer k  ^^  Used e  ^^  Agent e k  ^^  (Communication j || FindingInformation j)  -->  Patient e j"

(* Explanation 4: Communication(m)  -->  SharingInformation(m) *)
axiomatization where
  explanation_4: "Communication m  -->  SharingInformation m"

(* Explanation 5: Computer(n) ^^ Kind(n, Tools) *)
axiomatization where
  explanation_5: "Computer n  ^^  Kind n Tools"

(* Explanation 6: Radio(o) ^^ Kind(o, Tools) *)
axiomatization where
  explanation_6: "Radio o  ^^  Kind o Tools"
