theory question_66_1

imports Main

begin

typedecl entity

consts
  Sun :: "entity ⇒ bool"
  Star :: "entity ⇒ bool"
  Object :: "entity ⇒ bool"
  Planet :: "entity ⇒ bool"
  Earth :: "entity"
  Mars :: "entity"
  Moon :: "entity"
  Hotter :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: The Sun is a kind of star. *)
axiomatization where
  explanation_1: "∀x. Sun x ⟶ Star x"

(* Explanation 2: Stars are among the hottest objects, much hotter than planets such as the Earth and Mars, and the Moon. *)
axiomatization where
  explanation_2: "∀x y. Star x ∧ (Object y ∧ (Planet y ∧ (y = Earth ∨ y = Mars)) ∨ y = Moon) ⟶ Hotter x y"

(* Explanation 3: The Sun is hotter than the Earth, Mars, and the Moon. *)
axiomatization where
  explanation_3: "∀x. Sun x ⟶ Hotter x Earth ∧ Hotter x Mars ∧ Hotter x Moon"

theorem hypothesis:
  assumes asm: "Sun x"
  (* Hypothesis: The Sun is the hottest among the Earth, Mars, and the Moon. *)
  shows "Hottest x Earth ∧ Hottest x Mars ∧ Hottest x Moon"
proof -
  from asm have "Sun x" by simp
  then have "Hotter x Earth" and "Hotter x Mars" and "Hotter x Moon" using explanation_3 by simp+
  then show "Hottest x Earth ∧ Hottest x Mars ∧ Hottest x Moon" by simp
qed

end
