theory question_65_1

imports Main

begin

typedecl entity
consts
  Electricity :: "entity ⇒ bool"
  LightBulb :: "entity ⇒ bool"
  Flow :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  LightOn :: "entity ⇒ event ⇒ bool"
  Switch :: "entity ⇒ bool"
  SimpleSeriesCircuit :: "entity ⇒ bool"
  Closed :: "entity ⇒ bool"

(* Explanation: Electricity flows through a closed switch in a simple series circuit and reaches the light bulb, causing it to light up. *)
axiomatization where
  explanation: "∀x y z e. Switch x ∧ SimpleSeriesCircuit y ∧ Closed x ∧ Electricity z ∧ Flow e ∧ Agent e z ∧ Patient e x ⟶ ∃e'. LightBulb y ∧ Flow e' ∧ Agent e' z ∧ Patient e' x ∧ LightOn y e'"

theorem hypothesis:
  (* Premise: when the switch in a simple series circuit is closed *)
  assumes asm: "Switch x  ∧ SimpleSeriesCircuit y  ∧ Closed x "
  (* Hypothesis: When electricity is flowing to the light bulb, the light comes on. *)
  shows "∃x y e. Electricity x  ∧ LightBulb y  ∧ Flow e  ∧ Agent e  x  ∧ Patient e  y  ∧ LightOn y  e "
proof -
  from asm have "Electricity `z`" for z by (rule_tac x="z" in exI)
  then obtain e where e: "Flow e ∧ Agent e `z`" by (rule_tac x="z" in exI)
  then have "LightBulb y ∧ Flow e' ∧ Agent e' `z` ∧ Patient e' y ∧ LightOn y e'"
    using explanation[of x y z e `z`] by blast
  then show ?thesis using asm e by blast
qed

end
