theory question_11_2

imports Main

begin

typedecl entity
typedecl event

consts
  Plugging :: "event ⇒ bool"
  Many :: "entity ⇒ bool"
  Appliances :: "entity ⇒ bool"
  One :: "entity ⇒ bool"
  Outlet :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Safe :: "event ⇒ bool"
  Electricity :: "event ⇒ bool"

theorem hypothesis:
  assumes asm: " Plugging e ∧ Many x ∧ Appliances x ∧ One y ∧ Outlet y ∧ Agent e x ∧ Patient e y  ∧ ¬Safe e ∧ Electricity e"
  (* Hypothesis: Plugging many appliances into one outlet is not a way to stay safe around electricity. *)
  shows "∃x y e.  Plugging e ∧ Many x ∧ Appliances x ∧ One y ∧ Outlet y ∧ Agent e x ∧ Patient e y  ∧ ¬Safe e ∧ Electricity e"
proof -
  from asm have danger: "Plugging e ∧ Many x ∧ Appliances x ∧ One y ∧ Outlet y ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
  from danger have not_safe: "¬Safe e" using explanation_2 by blast
  show ?thesis using asm not_safe by blast
qed

end
