theory question_11_0

imports Main

begin

typedecl entity
typedecl event

consts
  IsPlugged :: "event ⇒ bool"
  ElectricalConductor :: "entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Into :: "event ⇒ entity ⇒ entity ⇒ bool"
  Completed :: "(entity ⇒ bool) ⇒ bool"
  circuit :: "event ⇒ entity"
  Source :: "event ⇒ entity ⇒ bool"
  ElectricalEnergy :: "entity ⇒ bool"
  Electricity :: "entity ⇒ bool"
  Many :: "entity ⇒ bool"
  Appliances :: "entity ⇒ bool"
  One :: "event ⇒ entity ⇒ bool"
  Danger :: "event ⇒ bool"
  Safe :: "event ⇒ bool"

(* Explanation 1: when an electrical conductor is plugged into an outlet, a circuit is completed. *)
axiomatization where
  explanation_1: "∀e x y. (IsPlugged e ∧ ElectricalConductor x ∧ Agent e x ∧ Patient e y ∧ Into e x y) ⟶ Completed (circuit e)"

(* Explanation 2: a complete electrical circuit is a source of electrical energy. *)
axiomatization where
  explanation_2: "∀e. Completed (circuit e) ⟶ Source e (ElectricalEnergy e)"

(* Explanation 3: electricity means electrical energy. *)
axiomatization where
  explanation_3: "∀e. Electricity e ⟷ ElectricalEnergy e"

(* Explanation 4: safe is the opposite of harm; danger. *)
axiomatization where
  explanation_4: "∀e. Safe e ⟷ ¬Danger e"

(* Explanation 5: plugging many appliances into one outlet is dangerous. *)
axiomatization where
  explanation_5: "∀e x y. (Plugging e ∧ Many x ∧ Appliances y ∧ Agent e x ∧ Patient e y ∧ Into e x y ∧ One e outlet) ⟶ Danger e"

theorem hypothesis:
  assumes asm: " Plugging e ∧ Many x ∧ Appliances y ∧ Agent e x ∧ Patient e y ∧ Into e x y ∧ One e outlet "
  (* Hypothesis: Plugging many appliances into one outlet is not a way to stay safe around electricity. *)
  shows "∃e. ∀s. Plugging e ∧ Many s ∧ Appliances s ∧ Agent e s ∧ Patient e s ∧ Into e s s ∧ One e outlet ∧ ¬Safe e around  Electricity e "
proof -
  from asm have "Plugging e" "Many x" "Appliances y" "Agent e x" "Patient e y" "Into e x y" "One e outlet" by simp_all
  then have "Danger e" using explanation_5 by blast
  then have "¬Safe e around Electricity e" using explanation_4 by blast
  then have "Plugging e ∧ Many s ∧ Appliances s ∧ Agent e s ∧ Patient e s ∧ Into e s s ∧ One e outlet ∧ ¬Safe e around Electricity e" using asm by simp
  then show ?thesis by blast
qed

end
