theory question_63_10

imports Main

begin

typedecl entity
typedecl event

consts
  Sandstone :: "entity ⇒ bool"
  SedimentaryRock :: "entity ⇒ bool"
  FormedByDeposition :: "entity ⇒ bool"
  Formed :: "event ⇒ entity ⇒ entity ⇒ bool"

(* Explanation 1: Sandstone is a form of sedimentary rock, and any rock that is formed by deposition is a sedimentary rock. *)
axiomatization where
  explanation_1: "∀x. Sandstone x ⟶ SedimentaryRock x ∧ (∃y. FormedByDeposition y ∧ Formed e x y)"

(* Explanation 2: Sedimentary rocks formed by deposition include sandstone. *)
axiomatization where
  explanation_2: "∀x y. SedimentaryRock x ∧ FormedByDeposition y ∧ Formed e x y ⟶ (∃z. Sandstone z ∧ z = x)"

theorem hypothesis:
  assumes asm: "Rocks x ∧ FormedByDeposition y ∧ Formed e x y"
  (* Hypothesis: Rocks formed by deposition are sandstone. *)
  shows "Sandstone x"
proof -
  from asm have "SedimentaryRock x" using explanation_1 by blast
  then have "SedimentaryRock x ∧ FormedByDeposition y ∧ Formed e x y" using asm by simp
  then have "∃z. Sandstone z ∧ z = x" using explanation_2 by blast
  then have "Sandstone x" by simp
  show ?thesis using asm `Sandstone x` by blast
qed

end
