theory question_47_2

imports Main

begin

typedecl entity

consts
  Genes :: "entity ⇒ bool"
  SameChromosome :: "entity ⇒ entity ⇒ bool"
  InheritedTogether :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Inherited :: "event ⇒ bool"

theorem hypothesis:
  assumes asm: "Genes g ∧ SameChromosome sc g ∧ InheritedTogether it ∧ Agent it g ∧ Patient it sc"
  (* Hypothesis: Genes (g) are inherited together (it) if they are located on the same chromosome (sc). *)
  shows "∃e. InheritedTogether it ∧ Agent it g ∧ Patient it sc ∧ Inherited e ∧ Patient e g"
proof -
  from asm have "InheritedTogether it ∧ Agent it g ∧ Patient it sc ∧ Genes g ∧ SameChromosome sc g" by simp
  then have "Inherited e ∧ Patient e g" using explanation_1 by blast
  then show ?thesis using asm `Inherited e` by blast
qed

end
