theory question_31_1
imports Main

begin

typedecl entity
typedecl event

consts
  Object :: "entity ⇒ bool"
  Shape :: "entity ⇒ bool"
  Sharpen :: "event ⇒ entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  ChangeShape :: "event ⇒ entity ⇒ bool"
  Removing :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Sharpening an object causes that object to change shape by removing material. *)
axiomatization where
  explanation_1: "∀x y z e1 e2. Object x ∧ Shape y ∧ Sharpen e1 x ∧ Agent e1 z ⟶ ChangeShape e2 x ∧ Agent e2 x ∧ Removing e2 y"

theorem hypothesis:
  assumes asm: "Object x ∧ Shape y ∧ ChangeShape e' x"
  (* Hypothesis: One way an object's shape can be changed is by removing material. *)
  shows "∃x y e. Object x ∧ Shape y ∧ ChangeShape e ∧ Agent e x ∧ Removing e y"
proof -
  from asm have "Object x" and "Shape y" and "ChangeShape e' x" by simp_all
  then obtain e where e: "ChangeShape e x ∧ Agent e x ∧ Removing e y" using explanation_1 by blast
  have conclusion: "ChangeShape e x ∧ Agent e x ∧ Removing e y" using e by simp
  show ?thesis using asm conclusion by blast
qed

end
