theory question_20_10
imports Main

begin

typedecl entity

consts
  Fur :: "entity ⇒ bool"
  Fiber :: "entity ⇒ bool"
  Unique :: "entity ⇒ bool"
  Animals :: "entity ⇒ bool"
  Mammals :: "entity ⇒ bool"
  Possessed :: "entity ⇒ entity ⇒ bool"
  Has :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Fur is a unique type of fiber that is not possessed by any animals other than mammals. *)
axiomatization where
  explanation_1: "∀x. Fur x ⟶ (∃y. Fiber y ∧ Unique x ∧ ∀z. Animals z ⟶ (z ≠ Mammals ⟶ ¬Possessed(x, z)))"

(* Explanation 2: If an entity has fur, then it is uniquely associated with mammals and not possessed by any other animals. *)
axiomatization where
  explanation_2: "∀x y. (Has x y ∧ Fur y) ⟶ (Mammals x ∧ ∀z. Animals z ⟶ (z ≠ Mammals ⟶ ¬Possessed(y, z)))"

theorem hypothesis:
  assumes asm: "Fur x"
  (* Hypothesis: Fur is unique to mammals. *)
  shows "Mammals x"
proof -
  from asm have "Fur x" by simp
  then have "∃y. Fiber y ∧ Unique x ∧ ∀z. Animals z ⟶ (z ≠ Mammals ⟶ ¬Possessed(x, z))" using explanation_1 by blast
  then have "Mammals x" by auto
  then show ?thesis by simp
qed

end
