theory question_85_8

imports Main

begin

typedecl entity

consts
  FlowerCartVendor :: "entity ⇒ bool"
  FlowerSeller :: "entity ⇒ bool"
  Vendor :: "entity ⇒ bool"
  Sells :: "entity ⇒ entity ⇒ entity ⇒ bool"
  OnSidewalk :: "entity ⇒ bool"

theorem hypothesis:
  (* Premise: Sidewalk flower cart vendor. *)
  assumes asm: "FlowerCartVendor x ∧ OnSidewalk x"
  (* Hypothesis: Flower seller on sidewalk. *)
  shows "∃x. FlowerSeller x ∧ OnSidewalk x"
proof -
  from asm have "FlowerCartVendor x" by blast
  then have "Vendor x" by blast
  then have "∃y. Sells x y y" by blast
  then have "∃y. FlowerSeller y" by blast
  then have "FlowerSeller z" for some z by blast
  from asm have "OnSidewalk x" by blast
  have "OnSidewalk z"
  proof -
    from asm have "FlowerCartVendor x" by blast
    then have "Vendor x" by blast
    then have "Sells x y z" for some y z by blast
    then have "OnSidewalk z" by blast
  qed

end
