theory question_85_5

imports Main

begin

typedecl entity

consts
  FlowerCartVendor :: "entity ⇒ bool"
  Vendor :: "entity ⇒ bool"
  Sells :: "entity ⇒ entity ⇒ bool"
  Flowers :: "entity"
  OnSidewalk :: "entity ⇒ bool"
  FlowerSeller :: "entity ⇒ bool"

(* Explanation 1: A flower cart vendor is a vendor who sells flowers on the sidewalk. *)
axiomatization where
  explanation_1: "∀x. FlowerCartVendor x ⟶ Vendor x ∧ Sells x Flowers ∧ OnSidewalk x"

(* Explanation 2: A vendor who sells flowers on the sidewalk is a flower seller on the sidewalk. *)
axiomatization where
  explanation_2: "∀x. Vendor x ∧ Sells x Flowers ∧ OnSidewalk x ⟶ FlowerSeller x ∧ OnSidewalk x"

theorem hypothesis:
  (* Premise: ∃x. FlowerCartVendor(x) ∧ OnSidewalk(x) ∧ Vend(x) *)
  assumes asm: "FlowerCartVendor x ∧ OnSidewalk x ∧ Vendor x"
  (* Hypothesis: ∃x. FlowerSeller(x) ∧ OnSidewalk(x) *)
  shows "∃x. FlowerSeller x ∧ OnSidewalk x"
proof -
  from asm have "FlowerCartVendor x ∧ OnSidewalk x ∧ Vendor x" by simp
  then have "Vendor x ∧ Sells x Flowers ∧ OnSidewalk x" using explanation_1 by blast
  then have "FlowerSeller x ∧ OnSidewalk x" using explanation_2 by blast
  then show ?thesis by blast
qed

end
