theory question_70_0

imports Main

begin

typedecl entity
typedecl event

consts
  Man :: "entity ⇒ bool"
  Woman :: "entity ⇒ bool"
  Two :: "entity ⇒ entity ⇒ bool"
  Looking :: "event ⇒ bool"
  StareAt :: "event ⇒ bool"
  Outside :: "event ⇒ bool"
  Skyline :: "event ⇒ bool"
  
(* Explanation: If there are two people, and they are staring at the skyline, then they must be looking outside. *)
axiomatization where
  explanation: "∀e x y. Man x ∧ Woman y ∧ Two x y ∧ StareAt e ∧ Agent e x ∧ Agent e y ∧ Skyline e ⟶ (∃e'. Looking e' ∧ Agent e' x ∧ Agent e' y ∧ Outside e')"

theorem hypothesis:
  (* Premise: A man and a woman stare at the skyline. *)
  assumes asm: "Man x ∧ Woman y ∧ Two x y ∧ StareAt e ∧ Agent e x ∧ Agent e y ∧ Skyline e"
  (* Hypothesis: The two people are looking outside. *)
  shows "∃x y e.  Man x ∧ Woman y  ∧ Two x y ∧ Looking e ∧ Agent e x ∧ Agent e y ∧ Outside e"
proof -
  from asm have "Man x ∧ Woman y ∧ Two x y ∧ StareAt e ∧ Agent e x ∧ Agent e y ∧ Skyline e" by blast
  then have "∃e'. Looking e' ∧ Agent e' x ∧ Agent e' y ∧ Outside e'"
    using explanation by blast
  then obtain e' where "Looking e' ∧ Agent e' x ∧ Agent e' y ∧ Outside e'" by force
  thus "∃x y e.  Man x ∧ Woman y  ∧ Two x y ∧ Looking e ∧ Agent e x ∧ Agent e y ∧ Outside e" using `x` `y` `e'` by blast
qed

end
